/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.WaitStatisticsClient;
import com.azure.resourcemanager.mysql.fluent.models.WaitStatisticInner;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.implementation.WaitStatisticImpl;
import com.azure.resourcemanager.mysql.models.WaitStatistic;
import com.azure.resourcemanager.mysql.models.WaitStatistics;
import com.azure.resourcemanager.mysql.models.WaitStatisticsInput;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class WaitStatisticsImpl
implements WaitStatistics {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(WaitStatisticsImpl.class);
    private final WaitStatisticsClient innerClient;
    private final MySqlManager serviceManager;

    public WaitStatisticsImpl(WaitStatisticsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public WaitStatistic get(String resourceGroupName, String serverName, String waitStatisticsId) {
        WaitStatisticInner inner = this.serviceClient().get(resourceGroupName, serverName, waitStatisticsId);
        if (inner != null) {
            return new WaitStatisticImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<WaitStatistic> getWithResponse(String resourceGroupName, String serverName, String waitStatisticsId, Context context) {
        Response<WaitStatisticInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, waitStatisticsId, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new WaitStatisticImpl((WaitStatisticInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public PagedIterable<WaitStatistic> listByServer(String resourceGroupName, String serverName, WaitStatisticsInput parameters) {
        PagedIterable<WaitStatisticInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, parameters);
        return Utils.mapPage(inner, inner1 -> new WaitStatisticImpl((WaitStatisticInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<WaitStatistic> listByServer(String resourceGroupName, String serverName, WaitStatisticsInput parameters, Context context) {
        PagedIterable<WaitStatisticInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, parameters, context);
        return Utils.mapPage(inner, inner1 -> new WaitStatisticImpl((WaitStatisticInner)((Object)inner1), this.manager()));
    }

    private WaitStatisticsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

