/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.ServerBasedPerformanceTiersClient;
import com.azure.resourcemanager.mysql.fluent.models.PerformanceTierPropertiesInner;
import com.azure.resourcemanager.mysql.implementation.PerformanceTierPropertiesImpl;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.PerformanceTierProperties;
import com.azure.resourcemanager.mysql.models.ServerBasedPerformanceTiers;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class ServerBasedPerformanceTiersImpl
implements ServerBasedPerformanceTiers {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(ServerBasedPerformanceTiersImpl.class);
    private final ServerBasedPerformanceTiersClient innerClient;
    private final MySqlManager serviceManager;

    public ServerBasedPerformanceTiersImpl(ServerBasedPerformanceTiersClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PerformanceTierProperties> list(String resourceGroupName, String serverName) {
        PagedIterable<PerformanceTierPropertiesInner> inner = this.serviceClient().list(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new PerformanceTierPropertiesImpl((PerformanceTierPropertiesInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PerformanceTierProperties> list(String resourceGroupName, String serverName, Context context) {
        PagedIterable<PerformanceTierPropertiesInner> inner = this.serviceClient().list(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new PerformanceTierPropertiesImpl((PerformanceTierPropertiesInner)inner1, this.manager()));
    }

    private ServerBasedPerformanceTiersClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

