/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.OperationsClient;
import com.azure.resourcemanager.mysql.fluent.models.OperationListResultInner;
import com.azure.resourcemanager.mysql.implementation.OperationListResultImpl;
import com.azure.resourcemanager.mysql.models.OperationListResult;
import com.azure.resourcemanager.mysql.models.Operations;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class OperationsImpl
implements Operations {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(OperationsImpl.class);
    private final OperationsClient innerClient;
    private final MySqlManager serviceManager;

    public OperationsImpl(OperationsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public OperationListResult list() {
        OperationListResultInner inner = this.serviceClient().list();
        if (inner != null) {
            return new OperationListResultImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public Response<OperationListResult> listWithResponse(Context context) {
        Response<OperationListResultInner> inner = this.serviceClient().listWithResponse(context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new OperationListResultImpl((OperationListResultInner)inner.getValue(), this.manager()));
        }
        return null;
    }

    private OperationsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

