/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.LogFilesClient;
import com.azure.resourcemanager.mysql.fluent.models.LogFileInner;
import com.azure.resourcemanager.mysql.implementation.LogFileImpl;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.LogFile;
import com.azure.resourcemanager.mysql.models.LogFiles;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class LogFilesImpl
implements LogFiles {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LogFilesImpl.class);
    private final LogFilesClient innerClient;
    private final MySqlManager serviceManager;

    public LogFilesImpl(LogFilesClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<LogFile> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<LogFileInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return Utils.mapPage(inner, inner1 -> new LogFileImpl((LogFileInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<LogFile> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<LogFileInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return Utils.mapPage(inner, inner1 -> new LogFileImpl((LogFileInner)((Object)inner1), this.manager()));
    }

    private LogFilesClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

