/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.LocationBasedPerformanceTiersClient;
import com.azure.resourcemanager.mysql.fluent.models.PerformanceTierPropertiesInner;
import com.azure.resourcemanager.mysql.implementation.PerformanceTierPropertiesImpl;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.LocationBasedPerformanceTiers;
import com.azure.resourcemanager.mysql.models.PerformanceTierProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;

public final class LocationBasedPerformanceTiersImpl
implements LocationBasedPerformanceTiers {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LocationBasedPerformanceTiersImpl.class);
    private final LocationBasedPerformanceTiersClient innerClient;
    private final MySqlManager serviceManager;

    public LocationBasedPerformanceTiersImpl(LocationBasedPerformanceTiersClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public PagedIterable<PerformanceTierProperties> list(String locationName) {
        PagedIterable<PerformanceTierPropertiesInner> inner = this.serviceClient().list(locationName);
        return Utils.mapPage(inner, inner1 -> new PerformanceTierPropertiesImpl((PerformanceTierPropertiesInner)inner1, this.manager()));
    }

    @Override
    public PagedIterable<PerformanceTierProperties> list(String locationName, Context context) {
        PagedIterable<PerformanceTierPropertiesInner> inner = this.serviceClient().list(locationName, context);
        return Utils.mapPage(inner, inner1 -> new PerformanceTierPropertiesImpl((PerformanceTierPropertiesInner)inner1, this.manager()));
    }

    private LocationBasedPerformanceTiersClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

