/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysql.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.mysql.MySqlManager;
import com.azure.resourcemanager.mysql.fluent.models.ConfigurationInner;
import com.azure.resourcemanager.mysql.implementation.Utils;
import com.azure.resourcemanager.mysql.models.Configuration;

public final class ConfigurationImpl
implements Configuration,
Configuration.Definition,
Configuration.Update {
    private ConfigurationInner innerObject;
    private final MySqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String configurationName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public String value() {
        return this.innerModel().value();
    }

    @Override
    public String description() {
        return this.innerModel().description();
    }

    @Override
    public String defaultValue() {
        return this.innerModel().defaultValue();
    }

    @Override
    public String dataType() {
        return this.innerModel().dataType();
    }

    @Override
    public String allowedValues() {
        return this.innerModel().allowedValues();
    }

    @Override
    public String source() {
        return this.innerModel().source();
    }

    @Override
    public ConfigurationInner innerModel() {
        return this.innerObject;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public ConfigurationImpl withExistingServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public Configuration create() {
        this.innerObject = this.serviceManager.serviceClient().getConfigurations().createOrUpdate(this.resourceGroupName, this.serverName, this.configurationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Configuration create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConfigurations().createOrUpdate(this.resourceGroupName, this.serverName, this.configurationName, this.innerModel(), context);
        return this;
    }

    ConfigurationImpl(String name, MySqlManager serviceManager) {
        this.innerObject = new ConfigurationInner();
        this.serviceManager = serviceManager;
        this.configurationName = name;
    }

    @Override
    public ConfigurationImpl update() {
        return this;
    }

    @Override
    public Configuration apply() {
        this.innerObject = this.serviceManager.serviceClient().getConfigurations().createOrUpdate(this.resourceGroupName, this.serverName, this.configurationName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public Configuration apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getConfigurations().createOrUpdate(this.resourceGroupName, this.serverName, this.configurationName, this.innerModel(), context);
        return this;
    }

    ConfigurationImpl(ConfigurationInner innerObject, MySqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = Utils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = Utils.getValueFromIdByName(innerObject.id(), "servers");
        this.configurationName = Utils.getValueFromIdByName(innerObject.id(), "configurations");
    }

    @Override
    public Configuration refresh() {
        this.innerObject = (ConfigurationInner)((Object)this.serviceManager.serviceClient().getConfigurations().getWithResponse(this.resourceGroupName, this.serverName, this.configurationName, Context.NONE).getValue());
        return this;
    }

    @Override
    public Configuration refresh(Context context) {
        this.innerObject = (ConfigurationInner)((Object)this.serviceManager.serviceClient().getConfigurations().getWithResponse(this.resourceGroupName, this.serverName, this.configurationName, context).getValue());
        return this;
    }

    @Override
    public ConfigurationImpl withValue(String value) {
        this.innerModel().withValue(value);
        return this;
    }

    @Override
    public ConfigurationImpl withSource(String source) {
        this.innerModel().withSource(source);
        return this;
    }
}

