/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.data.compare.model.impl.exporter;

import com.dbeaver.data.compare.model.DCChangeRelation;
import com.dbeaver.data.compare.model.DCChangeSet;
import com.dbeaver.data.compare.model.exporter.DCExporter;
import com.dbeaver.data.compare.model.exporter.DCExporterSite;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.data.DBDAttributeValue;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.dbeaver.model.struct.DBSAttributeBase;
import org.jkiss.dbeaver.model.struct.DBSDataManipulator;
import org.jkiss.utils.ArrayUtils;

public class DCExporterSQL
implements DCExporter {
    private DCExporterSite site;
    private DBCExecutionSource source;

    @Override
    public void init(@NotNull DCExporterSite site) throws DBException {
        if (!(site.getSettings().getLeftInput().getContainer() instanceof DBSDataManipulator) || !(site.getSettings().getRightInput().getContainer() instanceof DBSDataManipulator)) {
            throw new DBException("SQL generation from non-table is not supported");
        }
        this.site = site;
        this.source = new AbstractExecutionSource(site.getInput().getContainer(), site.getInput().getExecutionContext(), null);
    }

    @Override
    public void exportRow(@NotNull DBCSession session, @NotNull DCChangeSet changeSet) throws DBException, IOException {
        DBSDataManipulator manipulator = (DBSDataManipulator)this.site.getInput().getContainer();
        DBEPersistAction[] actions = DCExporterSQL.generateActions(changeSet, manipulator, session, this.source, this.site.getRelation());
        if (actions.length > 0) {
            this.site.getWriter().write(SQLUtils.generateScript((DBPDataSource)session.getDataSource(), (DBEPersistAction[])actions, (boolean)false));
        }
    }

    @NotNull
    private static DBEPersistAction[] generateActions(@NotNull DCChangeSet change, @NotNull DBSDataManipulator manipulator, @NotNull DBCSession session, @NotNull DBCExecutionSource source, @NotNull DCChangeRelation relation) throws DBException {
        DBSDataManipulator.ExecuteBatch batch;
        DBSAttributeBase[] sourceAttributes = DBDAttributeValue.getAttributes((DBDAttributeValue[])change.getSourceValues());
        DBSAttributeBase[] targetAttributes = DBDAttributeValue.getAttributes((DBDAttributeValue[])change.getTargetValues());
        DBSAttributeBase[] oppositeAttributes = relation.isSource() ? targetAttributes : sourceAttributes;
        DBSAttributeBase[] keyAttributes = DBDAttributeValue.getAttributes((DBDAttributeValue[])change.getKeys());
        Object[] sourceValues = DBDAttributeValue.getValues((DBDAttributeValue[])change.getSourceValues());
        Object[] targetValues = DBDAttributeValue.getValues((DBDAttributeValue[])change.getTargetValues());
        Object[] oppositeValues = relation.isSource() ? targetValues : sourceValues;
        Object[] keyValues = DBDAttributeValue.getValues((DBDAttributeValue[])change.getKeys());
        switch (change.getChangeType().getRelativeTo(relation)) {
            case INSERT: {
                batch = manipulator.insertData(session, oppositeAttributes, null, source, Collections.emptyMap());
                batch.add(oppositeValues);
                break;
            }
            case DELETE: {
                batch = manipulator.deleteData(session, keyAttributes, source);
                batch.add(keyValues);
                break;
            }
            default: {
                batch = manipulator.updateData(session, oppositeAttributes, keyAttributes, null, source);
                batch.add(ArrayUtils.concatArrays((Object[])oppositeValues, (Object[])keyValues));
            }
        }
        ArrayList actions = new ArrayList();
        batch.generatePersistActions(session, actions, Collections.emptyMap());
        return actions.toArray(new DBEPersistAction[0]);
    }
}

