/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.scmp.impl.liquibase;

import com.datical.liquibase.ext.storedlogic.checkconstraint.CheckConstraint;
import com.dbeaver.ee.scmp.model.CMPCompareEngine;
import com.dbeaver.ee.scmp.model.CMPOptions;
import com.dbeaver.ee.scmp.model.CMPReportEngine;
import com.dbeaver.ee.scmp.model.CMPResult;
import com.dbeaver.ee.scmp.model.CMPResultChangeItem;
import com.dbeaver.ee.scmp.model.ResultObjectInfo;
import com.dbeaver.ee.scmp.registry.SCMPDiffEngineDescriptor;
import com.dbeaver.ee.scmp.registry.SCMPEngineRegistry;
import com.dbeaver.ee.scmp.registry.SCMPReportEngineDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.diff.compare.CompareControl;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.Location;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import liquibase.structure.core.UniqueConstraint;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.impl.struct.RelationalObjectType;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObjectType;
import org.jkiss.dbeaver.model.task.DBTTask;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class LBUtils {
    private static final Log log = Log.getLog(LBUtils.class);
    public static final String VARIABLE_PROJECT = "project";
    public static final String VARIABLE_DATASOURCE = "datasource";
    public static final String VARIABLE_HOST = "host";
    public static final String VARIABLE_DATABASE = "database";
    public static final String VARIABLE_SCHEMA = "schema";
    private static final String VARIABLE_DATE = "date";
    private static final String VARIABLE_TIMESTAMP = "timestamp";
    private static final String VARIABLE_YEAR = "year";
    private static final String VARIABLE_MONTH = "month";
    private static final String VARIABLE_DAY = "day";
    public static final String[] ALL_VARIABLES = new String[]{"project", "datasource", "host", "database", "schema", "date", "timestamp", "year", "month", "day"};

    public static String getTargetSchema(CompareControl control, String sourceSchema) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null) {
                if (sc.getReferenceSchema().getSchemaName() != null && sc.getReferenceSchema().getSchemaName().equalsIgnoreCase(sourceSchema)) {
                    return sc.getComparisonSchema().getSchemaName();
                }
                if (sc.getReferenceSchema().getCatalogName() != null && sc.getReferenceSchema().getCatalogName().equalsIgnoreCase(sourceSchema)) {
                    return sc.getComparisonSchema().getCatalogName();
                }
            }
            ++n2;
        }
        return null;
    }

    public static CMPCompareEngine createDiffEngine(@NotNull CMPOptions options) {
        SCMPDiffEngineDescriptor diffEngineDescriptor = null;
        if (!CommonUtils.isEmpty((String)options.getDiffEngineId()) && (diffEngineDescriptor = SCMPEngineRegistry.getInstance().getDiffEngine(options.getDiffEngineId())) == null) {
            log.warn((Object)("Diff engine '" + options.getDiffEngineId() + "' not found. Use default."));
        }
        if (diffEngineDescriptor == null) {
            diffEngineDescriptor = SCMPEngineRegistry.getInstance().getDefaultDiffEngine();
        }
        CMPCompareEngine diffEngine = null;
        try {
            diffEngine = diffEngineDescriptor.createEngine();
        }
        catch (DBException e) {
            log.debug((Object)"Can't create comparison engine", (Throwable)e);
        }
        return diffEngine;
    }

    @NotNull
    public static String replaceVariables(@NotNull String name) {
        switch (name) {
            case "timestamp": {
                return RuntimeUtils.getCurrentTimeStamp();
            }
            case "date": {
                return RuntimeUtils.getCurrentDate();
            }
            case "year": {
                return new SimpleDateFormat("yyyy").format(new Date());
            }
            case "month": {
                return new SimpleDateFormat("MM").format(new Date());
            }
            case "day": {
                return new SimpleDateFormat("dd").format(new Date());
            }
        }
        return System.getProperty(name);
    }

    public static Path createReportFile(@NotNull SCMPReportEngineDescriptor engine) throws IOException {
        Path tempFolder = DBWorkbench.getPlatform().getTempFolder((DBRProgressMonitor)new VoidProgressMonitor(), "scmp-diff-reports");
        return tempFolder.resolve("diff-report-" + engine.getId() + "-" + new SimpleDateFormat("yyyyMMddHHmmss").format(System.currentTimeMillis()) + "." + engine.getFileExtension());
    }

    public static void createAndExportReportFile(@NotNull DBRProgressMonitor monitor, @NotNull DBTTask task, @NotNull CMPOptions options, @NotNull CMPResult cmpResult) throws DBException, IOException {
        SCMPReportEngineDescriptor descriptor = SCMPEngineRegistry.getInstance().getReportEngine(options.getReportEngineId());
        CMPReportEngine reportEngine = descriptor.createEngine();
        Path reportFile = LBUtils.createReportFile(descriptor);
        monitor.subTask("Generate report");
        Throwable throwable = null;
        Object var8_9 = null;
        try (OutputStream os = Files.newOutputStream(reportFile, new OpenOption[0]);){
            reportEngine.generateDiffReport(monitor, cmpResult, os);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        LBUtils.exportReportFile(options.getOutputFile(monitor, task.getProject()), reportFile);
    }

    public static void exportReportFile(@NotNull Path targetFile, @NotNull Path reportFile) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream is = Files.newInputStream(reportFile, new OpenOption[0]);){
                Throwable throwable2 = null;
                Object var6_10 = null;
                try (OutputStream os = Files.newOutputStream(targetFile, new OpenOption[0]);){
                    IOUtils.fastCopy((InputStream)is, (OutputStream)os);
                }
                catch (Throwable throwable3) {
                    if (throwable2 == null) {
                        throwable2 = throwable3;
                    } else if (throwable2 != throwable3) {
                        throwable2.addSuppressed(throwable3);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException e1) {
            DBWorkbench.getPlatformUI().showError("Save error", "Error saving report to file", (Throwable)e1);
        }
    }

    public static boolean checkLBLicense(@NotNull DBPPreferenceStore globalPreferences, @NotNull CMPOptions cmpOptions) {
        String property = System.getProperty("liquibase.license.key");
        String licenseInPreferences = globalPreferences.getString("@dbeaver-prop-lb-lic@");
        if (CommonUtils.isNotEmpty((String)property)) {
            return LBUtils.checkLicenseState(property, cmpOptions);
        }
        if (CommonUtils.isNotEmpty((String)licenseInPreferences)) {
            return LBUtils.checkLicenseState(licenseInPreferences, cmpOptions);
        }
        return false;
    }

    private static boolean checkLicenseState(@NotNull String key, @NotNull CMPOptions cmpOptions) {
        LicenseService licenseService = ((LicenseServiceFactory)Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class)).getLicenseService();
        Location licenseKeyLocation = new Location("property liquibaseProLicenseKey", key);
        LicenseInstallResult licenseInstallResult = licenseService.installLicense(new Location[]{licenseKeyLocation});
        if (licenseInstallResult.code == 0) {
            cmpOptions.setHasLiquibaseLicense(true);
            return true;
        }
        return false;
    }

    @Nullable
    public static String getParentName(@NotNull DatabaseObject object) {
        Relation table;
        if (object instanceof PrimaryKey || object instanceof CheckConstraint) {
            Table table2 = (Table)object.getAttribute("table", Table.class);
            if (table2 != null) {
                return table2.getName();
            }
        } else if (object instanceof Column) {
            Relation relation = ((Column)object).getRelation();
            if (relation != null) {
                return relation.getName();
            }
        } else if (object instanceof ForeignKey) {
            Table foreignKeyTable = ((ForeignKey)object).getForeignKeyTable();
            if (foreignKeyTable != null) {
                return foreignKeyTable.getName();
            }
        } else if ((object instanceof UniqueConstraint || object instanceof Index) && (table = (Relation)object.getAttribute("table", Relation.class)) != null) {
            return table.getName();
        }
        return null;
    }

    @NotNull
    public static Map<String, List<ResultObjectInfo>> getChangedItemsMap(@NotNull CMPResult result) {
        LinkedHashMap<String, List<ResultObjectInfo>> containerMap = new LinkedHashMap<String, List<ResultObjectInfo>>();
        for (CMPResultChangeItem cMPResultChangeItem : result.getChangeSet().getChangeItems()) {
            ResultObjectInfo objectInfo;
            String containerName = DBUtils.getSimpleQualifiedName((Object[])new Object[]{CommonUtils.notEmpty((String)cMPResultChangeItem.getCatalogName()), CommonUtils.notEmpty((String)cMPResultChangeItem.getSchemaName())});
            List objectInfoList = containerMap.computeIfAbsent(containerName, s -> new ArrayList());
            String objectName = cMPResultChangeItem.getObjectName();
            if (CommonUtils.isEmpty((String)objectName)) {
                log.warn((Object)("Can't detect change owner object name: " + cMPResultChangeItem.toString()));
                continue;
            }
            String innerName = cMPResultChangeItem.getInnerName();
            if (innerName == null) {
                objectInfo = new ResultObjectInfo(cMPResultChangeItem);
                objectInfoList.add(objectInfo);
                continue;
            }
            objectInfo = LBUtils.findObjectForInnerItem(objectInfoList, objectName, cMPResultChangeItem);
            if (objectInfo == null) continue;
            objectInfo.getInnerChanges().add(cMPResultChangeItem);
        }
        return containerMap;
    }

    private static ResultObjectInfo findObjectForInnerItem(@NotNull List<ResultObjectInfo> objectInfoList, String objectName, CMPResultChangeItem innerItem) {
        for (ResultObjectInfo info : objectInfoList) {
            if (!CommonUtils.equalObjects((Object)objectName, (Object)info.getObjectName())) continue;
            return info;
        }
        DBSObjectType innerType = innerItem.getObjectType();
        DBSObjectType outerType = innerType == RelationalObjectType.TYPE_TABLE_COLUMN || innerType == RelationalObjectType.TYPE_CONSTRAINT ? RelationalObjectType.TYPE_TABLE : RelationalObjectType.TYPE_TABLE;
        ResultObjectInfo objectInfo = new ResultObjectInfo(outerType, objectName);
        objectInfoList.add(objectInfo);
        return objectInfo;
    }

    public static String getSourceSchema(CompareControl control, String targetSchema) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null) {
                if (sc.getComparisonSchema().getSchemaName() != null && sc.getComparisonSchema().getSchemaName().equalsIgnoreCase(targetSchema)) {
                    return sc.getReferenceSchema().getSchemaName();
                }
                if (sc.getComparisonSchema().getCatalogName() != null && sc.getComparisonSchema().getCatalogName().equalsIgnoreCase(targetSchema)) {
                    return sc.getReferenceSchema().getCatalogName();
                }
            }
            ++n2;
        }
        return null;
    }

    public static String getSourceCatalog(CompareControl control, String targetCatalog) {
        CompareControl.SchemaComparison[] schemaComparisonArray = control.getSchemaComparisons();
        int n = schemaComparisonArray.length;
        int n2 = 0;
        while (n2 < n) {
            CompareControl.SchemaComparison sc = schemaComparisonArray[n2];
            if (sc.getReferenceSchema() != null && sc.getComparisonSchema().getCatalogName() != null && sc.getComparisonSchema().getCatalogName().equalsIgnoreCase(targetCatalog)) {
                return sc.getReferenceSchema().getCatalogName();
            }
            ++n2;
        }
        return null;
    }
}

