/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ee.qmdb.ui;

import com.dbeaver.ee.qm.internal.QMPluginService;
import com.dbeaver.model.qm.QMService;
import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.qm.filters.QMQueryFilter;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetFilterManager;

public class QMDBResultSetFilterManager
implements IResultSetFilterManager {
    private static final Log log = Log.getLog(QMDBResultSetFilterManager.class);

    @NotNull
    public synchronized Collection<String> getQueryFilterHistory(@NotNull DBCExecutionContext context, @NotNull String query) throws DBException {
        QMService qmService = QMPluginService.getQmService();
        if (qmService == null) {
            return Collections.emptyList();
        }
        String sessionId = QMUtils.getQmSessionId((DBCExecutionContext)context);
        if (sessionId == null) {
            return Collections.emptyList();
        }
        return qmService.getQueryFilterHistory(sessionId, query);
    }

    public synchronized void saveQueryFilterValue(@NotNull DBCExecutionContext context, @NotNull String query, @NotNull String filterValue) throws DBException {
        QMService qmService = QMPluginService.getQmService();
        if (qmService == null) {
            return;
        }
        String sessionId = QMUtils.getQmSessionId((DBCExecutionContext)context);
        if (sessionId == null) {
            return;
        }
        qmService.saveQueryFilterValue(sessionId, new QMQueryFilter(query, filterValue));
    }

    public synchronized void deleteQueryFilterValue(@NotNull DBCExecutionContext context, @NotNull String query, String filterValue) throws DBException {
        QMService qmService = QMPluginService.getQmService();
        if (qmService == null) {
            return;
        }
        String sessionId = QMUtils.getQmSessionId((DBCExecutionContext)context);
        if (sessionId == null) {
            return;
        }
        qmService.deleteQueryFilterValue(sessionId, new QMQueryFilter(query, filterValue));
    }
}

