/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.dataset.handlers;

import com.dbeaver.model.dataset.DBDDataSet;
import com.dbeaver.model.dataset.DBDDataSetQuery;
import com.dbeaver.model.dataset.storage.DatasetStorage;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import com.dbeaver.ui.editors.dataset.DatasetHandlerImpl;
import java.io.IOException;
import java.util.UUID;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.app.DBPWorkspace;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.navigator.NavigatorResources;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.model.struct.rdb.DBSTable;
import org.jkiss.dbeaver.model.struct.rdb.DBSView;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.IResultSetController;
import org.jkiss.dbeaver.ui.controls.resultset.ResultSetViewer;
import org.jkiss.dbeaver.ui.controls.resultset.handler.ResultSetHandlerMain;
import org.jkiss.dbeaver.ui.dialogs.EnterNameDialog;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public class DataSetCreateHandler
extends AbstractHandler {
    private String datasetDescription;

    public Object execute(ExecutionEvent event) {
        String datasetName;
        IResultSetController resultSet = ResultSetHandlerMain.getActiveResultSet((IWorkbenchPart)HandlerUtil.getActivePart((ExecutionEvent)event));
        if (resultSet == null) {
            return null;
        }
        Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        EnterNameDialog dialog = new EnterNameDialog(activeShell, "Dataset name", null){
            private Text description;

            protected Composite createDialogArea(Composite parent) {
                Composite area = super.createDialogArea(parent);
                this.description = UIUtils.createLabelText((Composite)area, (String)"Description", null);
                return area;
            }

            protected void okPressed() {
                DataSetCreateHandler.this.datasetDescription = this.description.getText();
                super.okPressed();
            }
        };
        if (dialog.open() == 0 && !CommonUtils.isEmpty((String)(datasetName = dialog.getResult()))) {
            try {
                this.createNewDataset(resultSet, datasetName);
            }
            catch (IOException | DBException e) {
                DBWorkbench.getPlatformUI().showError("Create dataset", NLS.bind((String)"Cannot create new dataset \"{0}\"", (Object)datasetName), e);
            }
        }
        return null;
    }

    private void createNewDataset(@NotNull IResultSetController resultSet, @NotNull String datasetName) throws DBException, IOException {
        DBNProject projectNode;
        DBNResource resource;
        DBSDataContainer dataContainer;
        DBPProject project = resultSet.getContainer().getProject();
        if (project == null) {
            throw new DBException("The project was not found. Can't create a dataset without a project.");
        }
        DBPWorkspace workspace = DBWorkbench.getPlatform().getWorkspace();
        RMController rmController = null;
        if (workspace instanceof DesktopWorkspaceRemote) {
            rmController = ((DesktopWorkspaceRemote)workspace).getResourceController();
        }
        if (rmController == null) {
            throw new DBException("The remote controller was not found. Can't create a dataset without a remote controller.");
        }
        DBDDataSet dataSet = new DBDDataSet(datasetName);
        dataSet.setDescription(this.datasetDescription);
        DBDDataSetQuery query = new DBDDataSetQuery(UUID.randomUUID().toString());
        if (resultSet instanceof ResultSetViewer) {
            String queryText = ((ResultSetViewer)resultSet).getActiveQueryText();
            if (CommonUtils.isEmpty((String)queryText)) {
                throw new DBException("The resultset query was not found. Can't create a dataset without a resultset query text.");
            }
            query.setQueryText(queryText);
        }
        if ((dataContainer = resultSet.getDataContainer()) != null) {
            DBSEntity singleSource;
            DBSObject parentObject;
            DBPDataSource dataSource = dataContainer.getDataSource();
            if (dataSource != null) {
                query.setDataSourceContainer(dataSource.getContainer());
            }
            if (!((parentObject = dataContainer.getParentObject()) instanceof DBSStructContainer) && ((singleSource = resultSet.getModel().getSingleSource()) instanceof DBSTable || singleSource instanceof DBSView)) {
                parentObject = singleSource.getParentObject();
            }
            if (parentObject instanceof DBSSchema) {
                query.setSchema(parentObject.getName());
                DBSObject grandParentObject = parentObject.getParentObject();
                if (grandParentObject instanceof DBSCatalog) {
                    query.setCatalog(grandParentObject.getName());
                }
            } else if (parentObject instanceof DBSCatalog) {
                query.setCatalog(parentObject.getName());
            }
        }
        if (resultSet.getDataFilter() != null) {
            query.setDataFilters(resultSet.getDataFilter());
        }
        dataSet.addQuery(query);
        byte[] bytes = new DatasetStorage(dataSet).serialize().readAllBytes();
        String datasetPath = "Datasets/" + datasetName + (datasetName.endsWith(".ds") ? "" : ".ds");
        rmController.setResourceContents(project.getId(), datasetPath, bytes, false);
        IFolder datasetsRoot = DBPPlatformDesktop.getInstance().getWorkspace().getResourceDefaultRoot(project, DatasetHandlerImpl.class, false);
        if (datasetsRoot != null && (resource = NavigatorResources.findResource((DBNNode)(projectNode = DBWorkbench.getPlatform().getNavigatorModel().getRoot().getProjectNode(project)), (IResource)datasetsRoot)) != null) {
            new AbstractJob("Datasets node refresh"){

                protected IStatus run(DBRProgressMonitor monitor) {
                    try {
                        resource.refreshNode(monitor, null);
                    }
                    catch (DBException e) {
                        return GeneralUtils.makeExceptionStatus((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
    }
}

