/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.editors.dataset;

import com.dbeaver.model.dataset.DBDDataSetQuery;
import com.dbeaver.model.dataset.storage.DatasetStorage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPPlatformDesktop;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SqlJobResult;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.model.struct.rdb.DBSSchema;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.resultset.QueryResultsDecorator;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.StringEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class DataSetEditor
extends SQLEditor
implements IResourceChangeListener {
    private boolean datasetOpened = false;
    private String dataSetName;
    private DBDDataSetQuery firstQuery;
    private IFile dsFile;
    private volatile DataSetQueriesJobContext currentJobContext = null;

    protected void onDataSourceChange(boolean contextChanged) {
        super.onDataSourceChange(contextChanged);
        if (!this.datasetOpened && this.getExecutionContext() != null) {
            this.datasetOpened = true;
            UIUtils.asyncExec(() -> this.processSQL(false, true));
        } else if (contextChanged && this.currentJobContext != null && this.currentJobContext.isJobPreparationAccomplished()) {
            this.currentJobContext.initiateJob();
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        super.init(site, editorInput);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    protected boolean isHideQueryText() {
        return true;
    }

    protected boolean canProcessQueries() {
        return true;
    }

    protected void setDocumentProvider(IEditorInput input) {
        super.setDocumentProvider(input);
    }

    protected void doSetInput(IEditorInput editorInput) throws CoreException {
        this.dsFile = EditorUtils.getFileFromInput((IEditorInput)editorInput);
        if (this.dsFile == null) {
            throw new CoreException(GeneralUtils.makeErrorStatus((String)"Dataset input is not a file"));
        }
        DBPProject project = DBPPlatformDesktop.getInstance().getWorkspace().getProject(this.dsFile.getProject());
        if (project == null) {
            throw new CoreException(GeneralUtils.makeErrorStatus((String)("Cannot detect project of file '" + this.dsFile.getName() + "'")));
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            Throwable throwable = null;
            Object var5_8 = null;
            try (InputStream is = this.dsFile.getContents();){
                IOUtils.copyStream((InputStream)is, (OutputStream)buffer);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((String)"Error reading datasource contents", (Throwable)e));
        }
        try {
            DatasetStorage storage = new DatasetStorage(this.dsFile.getName(), buffer.toByteArray(), project.getDataSourceRegistry());
            List queries = storage.getDataSet().getQueries();
            if (CommonUtils.isEmpty((Collection)queries)) {
                throw new CoreException(GeneralUtils.makeErrorStatus((String)"Cannot read dataset queries."));
            }
            this.firstQuery = (DBDDataSetQuery)queries.get(0);
            DBPDataSourceContainer dataSourceContainer = null;
            StringBuilder sqlText = new StringBuilder();
            for (DBDDataSetQuery q : queries) {
                sqlText.append(q.getQueryText());
                if (dataSourceContainer != null) continue;
                dataSourceContainer = q.getDataSourceContainer();
            }
            this.dataSetName = this.dsFile.getFullPath().removeFileExtension().lastSegment();
            StringEditorInput sqlInput = new StringEditorInput(this.dataSetName, (CharSequence)sqlText.toString(), true, GeneralUtils.DEFAULT_ENCODING);
            EditorUtils.setInputInputFile((IEditorInput)sqlInput, (IFile)this.dsFile);
            super.doSetInput((IEditorInput)sqlInput);
            if (dataSourceContainer != null) {
                this.setDataSourceContainer(dataSourceContainer);
                String dsName = dataSourceContainer.getName();
                this.checkConnected(true, status -> UIUtils.asyncExec(() -> {
                    if (!status.isOK()) {
                        DBWorkbench.getPlatformUI().showError("Can't connect to database", "Connection to '" + dsName + "' cannot be established.", status);
                    }
                    this.setFocus();
                }));
            }
        }
        catch (DBException e) {
            throw new CoreException(GeneralUtils.makeExceptionStatus((String)"Error opening datasource storage", (Throwable)e));
        }
    }

    public boolean processQueries(@NotNull List<SQLScriptElement> queries, boolean forceScript, boolean newTab, boolean export, boolean checkSession, @Nullable SQLQueryListener queryListener, @Nullable SQLScriptContext context) {
        if (this.currentJobContext == null) {
            this.currentJobContext = new DataSetQueriesJobContext(queryListener, l -> {
                boolean bl5 = DataSetEditor.super.processQueries(queries, forceScript, newTab, export, checkSession, l, context);
            });
            if (this.currentJobContext.isJobPreparationAccomplished()) {
                this.currentJobContext.initiateJob();
            } else {
                try {
                    this.currentJobContext.applyFirstQueryDataContext();
                }
                catch (InterruptedException | InvocationTargetException e) {
                    log.error((Object)e);
                    DBWorkbench.getPlatformUI().showError("Data set preparation error", "Failed to switch data context while preparing data set query for execution", (Throwable)e);
                }
            }
            return true;
        }
        return false;
    }

    public boolean supportsRename() {
        return false;
    }

    protected boolean isDetectTitleImageFromInput() {
        return false;
    }

    protected String getEditorName() {
        return this.dataSetName;
    }

    @NotNull
    protected QueryResultsDecorator createQueryResultsDecorator() {
        return new QueryResultsDecorator(){

            public String getEmptyDataMessage() {
                return "Loading data";
            }

            public String getEmptyDataDescription() {
                return "Wait while dataset is being initialized";
            }
        };
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta == null) {
            return;
        }
        if (this.dsFile == null) {
            return;
        }
        if ((delta = delta.findMember(this.dsFile.getFullPath())) == null) {
            return;
        }
        if (delta.getKind() == 2) {
            if ((0x2000 & delta.getFlags()) != 0) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IFile newFile = workspace.getRoot().getFile(delta.getMovedToPath());
                UIUtils.syncExec(() -> {
                    this.setInput((IEditorInput)new FileEditorInput(newFile));
                    this.setPartName(this.getEditorInput().getName());
                });
            } else {
                UIUtils.asyncExec(() -> {
                    boolean bl = this.getSite().getWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
                });
            }
        }
    }

    private class DataSetQueriesJobContext
    implements SQLQueryListener {
        private final SQLQueryListener queryListener;
        private final Consumer<SQLQueryListener> initiateQueriesJobProc;
        private DBSCatalog startDefaultCatalog = null;
        private DBSSchema startDefaultSchema = null;
        private String desiredCatalogName = null;
        private String desiredSchemaName = null;
        private volatile boolean initialized = false;

        private DataSetQueriesJobContext(SQLQueryListener queryListener, Consumer<SQLQueryListener> initiateQueriesJobProc) {
            DBPDataSource dataSource;
            this.queryListener = queryListener;
            this.initiateQueriesJobProc = initiateQueriesJobProc;
            if (DataSetEditor.this.firstQuery != null && (dataSource = DataSetEditor.this.firstQuery.getDataSourceContainer().getDataSource()) instanceof DBSObjectContainer) {
                this.desiredCatalogName = DataSetEditor.this.firstQuery.getCatalog();
                this.desiredSchemaName = DataSetEditor.this.firstQuery.getSchema();
            }
        }

        public void initiateJob() {
            UIUtils.asyncExec(() -> this.initiateQueriesJobProc.accept(this));
        }

        public void onStartScript() {
            if (this.queryListener != null) {
                this.queryListener.onStartScript();
            }
        }

        public void onStartQuery(DBCSession session, SQLQuery query) {
            if (this.queryListener != null) {
                this.queryListener.onStartQuery(session, query);
            }
        }

        public boolean isJobPreparationAccomplished() {
            DBCExecutionContextDefaults currDefaults;
            DBCExecutionContext executionContext;
            if (!this.initialized && (executionContext = DataSetEditor.this.getExecutionContext()) != null && DataSetEditor.this.firstQuery != null && (currDefaults = executionContext.getContextDefaults()) != null) {
                boolean isDefaultSchemaDesired;
                DBSCatalog currDefaultCatalog = currDefaults.getDefaultCatalog();
                DBSSchema currDefaultSchema = currDefaults.getDefaultSchema();
                boolean isDefaultCatalogDesired = currDefaultCatalog == null || currDefaultCatalog.getName().equals(this.desiredCatalogName);
                boolean bl = isDefaultSchemaDesired = currDefaultSchema == null || currDefaultSchema.getName().equals(this.desiredSchemaName);
                if (isDefaultCatalogDesired && isDefaultSchemaDesired) {
                    this.initialized = true;
                    return true;
                }
            }
            return false;
        }

        public void applyFirstQueryDataContext() throws InterruptedException, InvocationTargetException {
            DBPDataSource dataSource;
            DBCExecutionContextDefaults contextDefaults;
            DBCExecutionContext executionContext = DataSetEditor.this.getExecutionContext();
            if (executionContext != null && DataSetEditor.this.firstQuery != null && (contextDefaults = executionContext.getContextDefaults()) != null && DataSetEditor.this.firstQuery != null && (dataSource = DataSetEditor.this.firstQuery.getDataSourceContainer().getDataSource()) instanceof DBSObjectContainer) {
                this.startDefaultCatalog = contextDefaults.getDefaultCatalog();
                this.startDefaultSchema = contextDefaults.getDefaultSchema();
                UIUtils.runInProgressService(monitor -> {
                    try {
                        DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)monitor, (DBPDataSource)dataSource, (DBCExecutionContext)executionContext, (String)this.desiredCatalogName, null, (String)this.desiredSchemaName);
                    }
                    catch (DBException e) {
                        log.error((Object)"Can't set default catalog/schema for dataset.", (Throwable)e);
                    }
                });
            }
        }

        public void onEndQuery(DBCSession session, SQLQueryResult result, DBCStatistics statistics) {
            if (this.queryListener != null) {
                this.queryListener.onEndQuery(session, result, statistics);
            }
        }

        public void onEndScript(DBCStatistics statistics, boolean hasErrors) {
            if (this.queryListener != null) {
                this.queryListener.onEndScript(statistics, hasErrors);
            }
        }

        public void onEndSqlJob(DBCSession session, SqlJobResult result) {
            DBPDataSource dataSource;
            if (this.queryListener != null) {
                this.queryListener.onEndSqlJob(session, result);
            }
            if (session != null && (dataSource = DataSetEditor.this.firstQuery.getDataSourceContainer().getDataSource()) instanceof DBSObjectContainer) {
                try {
                    DBCExecutionContext executionContext = DataSetEditor.this.getExecutionContext();
                    DBExecUtils.setExecutionContextDefaults((DBRProgressMonitor)session.getProgressMonitor(), (DBPDataSource)dataSource, (DBCExecutionContext)executionContext, (String)(this.startDefaultCatalog != null ? this.startDefaultCatalog.getName() : null), null, this.startDefaultSchema != null ? this.startDefaultSchema.getName() : null);
                }
                catch (DBException e) {
                    log.error((Object)"Can't return default catalog/schema.", (Throwable)e);
                }
            }
            if (DataSetEditor.this.currentJobContext == this) {
                DataSetEditor.this.currentJobContext = null;
            }
        }
    }
}

