/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.ycql.model;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.addresstranslation.AddressTranslator;
import com.datastax.oss.driver.api.core.auth.AuthProvider;
import com.datastax.oss.driver.api.core.auth.ProgrammaticPlainTextAuthProvider;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.internal.core.type.PrimitiveType;
import com.datastax.oss.protocol.internal.ProtocolConstants;
import com.dbeaver.db.ycql.CasUtils;
import com.dbeaver.db.ycql.exec.CasSession;
import com.dbeaver.db.ycql.model.CasCQLDialect;
import com.dbeaver.db.ycql.model.CasDataSourceInfo;
import com.dbeaver.db.ycql.model.CasDataType;
import com.dbeaver.db.ycql.model.CasExecutionContext;
import com.dbeaver.db.ycql.model.CasHost;
import com.dbeaver.db.ycql.model.CasKeyspace;
import com.dbeaver.db.ycql.model.CasPrivilege;
import com.dbeaver.db.ycql.model.CasRole;
import com.dbeaver.db.ycql.model.CasStructureAssistant;
import com.dbeaver.db.ycql.model.CasTupleType;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPDataTypeProvider;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPTermProvider;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.access.DBAAuthModel;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSimpleDataSource;
import org.jkiss.dbeaver.model.impl.net.SSLHandlerTrustStoreImpl;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.net.DBWHandlerConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.utils.CommonUtils;

public class CasDataSource
extends AbstractSimpleDataSource<CasExecutionContext>
implements DBPRefreshableObject,
DBPTermProvider,
DBPDataTypeProvider,
DBPErrorAssistant,
IAdaptable {
    private static final Log log = Log.getLog(CasDataSource.class);
    private static final Pattern ERROR_POSITION_PATTERN = Pattern.compile("line\\s+([0-9]+):([0-9]+)");
    @NotNull
    private CqlSession cqlSession;
    private KeyspaceCache keyspaceCache = new KeyspaceCache();
    private List<CasHost> hosts;
    private List<CasRole> roles;
    private CasDataSourceInfo info;
    @NotNull
    private final Map<String, CasDataType> typeMap = new LinkedHashMap<String, CasDataType>();
    private final Map<TupleType, CasTupleType> tupleTypeCache = new LinkedHashMap<TupleType, CasTupleType>();
    private final Map<String, CasPrivilege> privilegeMap = new HashMap<String, CasPrivilege>();

    public CasDataSource(DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(container);
        Field[] fields;
        container.getDriver().getDefaultDriverLoader().loadDriver(monitor);
        Field[] fieldArray = fields = ProtocolConstants.DataType.class.getFields();
        int n = fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            try {
                int i = field.getInt(null);
                PrimitiveType type = new PrimitiveType(i);
                this.typeMap.put(type.toString(), new CasDataType(this, (DataType)type));
            }
            catch (IllegalAccessException illegalAccessException) {
                log.error((Object)"Error accessing type list");
            }
            ++n2;
        }
        this.initializeCluster(monitor);
    }

    public DBWHandlerConfiguration getCustomSSLConfiguration(DBRProgressMonitor monitor, DBPConnectionConfiguration connectionInfo) {
        return null;
    }

    protected ConsistencyLevel getDefaultConsistencyLevel() {
        return ConsistencyLevel.ONE;
    }

    public void initializeCluster(DBRProgressMonitor monitor) throws DBException {
        if (this.executionContext == null) {
            this.executionContext = this.createExecutionContext("Main CQL Connection", this.getContainer().getActualConnectionConfiguration().getDatabaseName());
        }
        ((CasExecutionContext)this.executionContext).connect(monitor);
    }

    @NotNull
    protected CasExecutionContext createExecutionContext(String purpose, String keyspaceName) {
        return new CasExecutionContext(this, purpose, keyspaceName);
    }

    public void configureCluster(DBRProgressMonitor monitor) throws DBException {
        String addrTranslatorClassName;
        boolean tcpNoDelay;
        String sendBufferSize;
        String recvBufferSize;
        boolean reuseAddress;
        boolean keepAlive;
        String readTimeout;
        DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
        DBAAuthModel authModel = connectionInfo.getAuthModel();
        DBAAuthCredentials credentials = authModel.loadCredentials(this.getContainer(), connectionInfo);
        authModel.initAuthentication(monitor, (DBPDataSource)this, credentials, connectionInfo, new Properties());
        CqlSessionBuilder builder = CqlSession.builder();
        if (this.executionContext != null && this.getDefaultKeyspaceName() != null) {
            builder.withKeyspace(this.getDefaultKeyspaceName());
        }
        this.configureEndpoint(connectionInfo, builder);
        this.configureAuth(monitor, builder, connectionInfo);
        this.configureSSL(monitor, builder);
        ProgrammaticDriverConfigLoaderBuilder driverBuilder = DriverConfigLoader.programmaticBuilder();
        if (connectionInfo.getKeepAliveInterval() > 0) {
            driverBuilder.withDuration((DriverOption)DefaultDriverOption.HEARTBEAT_INTERVAL, Duration.ofSeconds(connectionInfo.getKeepAliveInterval()));
        }
        String sessionName = "DBeaver_Session";
        driverBuilder.withString((DriverOption)DefaultDriverOption.SESSION_NAME, sessionName);
        String connTimeout = connectionInfo.getProviderProperty("@dbeaver-cas.timeout.connect@");
        if (!CommonUtils.isEmpty((String)connTimeout)) {
            driverBuilder.withDuration((DriverOption)DefaultDriverOption.CONNECTION_CONNECT_TIMEOUT, Duration.ofSeconds(CommonUtils.toInt((Object)connTimeout)));
        }
        if (!CommonUtils.isEmpty((String)(readTimeout = connectionInfo.getProviderProperty("@dbeaver-cas.timeout.read@")))) {
            driverBuilder.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(CommonUtils.toInt((Object)readTimeout)));
        }
        if (keepAlive = CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-cas.net.keepAlive@"), (boolean)false)) {
            driverBuilder.withBoolean((DriverOption)DefaultDriverOption.SOCKET_KEEP_ALIVE, true);
        }
        if (reuseAddress = CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-cas.net.reuseAddr@"), (boolean)false)) {
            driverBuilder.withBoolean((DriverOption)DefaultDriverOption.SOCKET_REUSE_ADDRESS, true);
        }
        if (!CommonUtils.isEmpty((String)(recvBufferSize = connectionInfo.getProviderProperty("@dbeaver-cas.net.receiveBufferSize@")))) {
            driverBuilder.withInt((DriverOption)DefaultDriverOption.SOCKET_RECEIVE_BUFFER_SIZE, CommonUtils.toInt((Object)recvBufferSize));
        }
        if (!CommonUtils.isEmpty((String)(sendBufferSize = connectionInfo.getProviderProperty("@dbeaver-cas.net.sendBufferSize@")))) {
            driverBuilder.withInt((DriverOption)DefaultDriverOption.SOCKET_SEND_BUFFER_SIZE, CommonUtils.toInt((Object)sendBufferSize));
        }
        driverBuilder.withStringList((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, List.of());
        String soLinger = connectionInfo.getProviderProperty("@dbeaver-cas.net.soLinger@");
        if (!CommonUtils.isEmpty((String)soLinger)) {
            driverBuilder.withInt((DriverOption)DefaultDriverOption.SOCKET_LINGER_INTERVAL, CommonUtils.toInt((Object)soLinger));
        }
        if (tcpNoDelay = CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-cas.net.tcpNoDelay@"), (boolean)false)) {
            driverBuilder.withBoolean((DriverOption)DefaultDriverOption.SOCKET_TCP_NODELAY, true);
        }
        if (!CommonUtils.isEmpty((String)(addrTranslatorClassName = connectionInfo.getProviderProperty("cas.net.tcpAddressTranslator")))) {
            try {
                ClassLoader classLoader = this.getContainer().getDriver().getDefaultDriverLoader().getClassLoader();
                if (classLoader == null) {
                    throw new IllegalStateException("No driver classloader");
                }
                Class<?> atc = classLoader.loadClass(addrTranslatorClassName);
                if (!AddressTranslator.class.isAssignableFrom(atc)) {
                    throw new IllegalArgumentException("Class " + addrTranslatorClassName + " doesn't implement " + AddressTranslator.class.getName() + " interface");
                }
                AddressTranslator addressTranslator = (AddressTranslator)atc.getConstructor(new Class[0]).newInstance(new Object[0]);
                driverBuilder.withClass((DriverOption)DefaultDriverOption.ADDRESS_TRANSLATOR_CLASS, addressTranslator.getClass());
            }
            catch (Throwable e) {
                log.error((Object)("Error loading address translator class '" + addrTranslatorClassName + "'"), e);
            }
        }
        builder.withConfigLoader(driverBuilder.build());
        this.cqlSession = (CqlSession)builder.build();
    }

    protected void configureEndpoint(DBPConnectionConfiguration connectionInfo, CqlSessionBuilder builder) throws DBException {
        String hostName = connectionInfo.getHostName();
        String hostPort = connectionInfo.getHostPort();
        String datacenter = connectionInfo.getProviderProperty("@dbeaver-cas.net.datacenter@");
        try {
            if (!CommonUtils.isEmpty((String)hostName)) {
                String extraCP;
                builder.addContactPoint(new InetSocketAddress(InetAddress.getByName(hostName.trim()), Integer.parseInt(hostPort)));
                if (!CommonUtils.isEmpty((String)datacenter)) {
                    builder.withLocalDatacenter(datacenter);
                }
                if (!CommonUtils.isEmpty((String)(extraCP = connectionInfo.getProviderProperty("@dbeaver-connection.points@")))) {
                    String[] hostNames;
                    String[] stringArray = hostNames = extraCP.split(",");
                    int n = hostNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String host = stringArray[n2];
                        builder.addContactPoint(new InetSocketAddress(InetAddress.getByName(host.trim()), Integer.parseInt(hostPort)));
                        ++n2;
                    }
                }
            }
        }
        catch (UnknownHostException e) {
            throw new DBException("Error configuring endpoint", (Throwable)e);
        }
    }

    public String getDefaultKeyspaceName() {
        return ((CasExecutionContext)this.executionContext).getSelectedKeyspace();
    }

    public boolean supportsPermissions() {
        return true;
    }

    protected void configureAuth(DBRProgressMonitor monitor, CqlSessionBuilder builder, DBPConnectionConfiguration connectionInfo) throws DBException {
        if (!CommonUtils.isEmpty((String)connectionInfo.getUserName())) {
            builder.withAuthProvider((AuthProvider)new ProgrammaticPlainTextAuthProvider(connectionInfo.getUserName(), connectionInfo.getUserPassword()));
        }
    }

    protected void configureSSL(DBRProgressMonitor monitor, CqlSessionBuilder builder) throws DBException {
        DBWHandlerConfiguration sslConfig = this.getContainer().getActualConnectionConfiguration().getHandler("ycql_ssl");
        if (sslConfig == null) {
            sslConfig = this.getCustomSSLConfiguration(monitor, this.getContainer().getActualConnectionConfiguration());
        }
        if (sslConfig != null && sslConfig.isEnabled()) {
            byte[] trustStoreData = SSLHandlerTrustStoreImpl.readTrustStoreData((DBWHandlerConfiguration)sslConfig, (String)"ssl.keystore");
            String trustStorePassword = sslConfig.getStringProperty(sslConfig.getPassword());
            String clientCert = sslConfig.getStringProperty("ssl.client.cert");
            String clientKey = sslConfig.getStringProperty("ssl.client.key");
            try {
                SSLContext sslContext = SSLContext.getInstance("TLS");
                if (trustStoreData != null && trustStoreData.length != 0) {
                    KeyStore ks = KeyStore.getInstance("JKS");
                    Throwable throwable = null;
                    Object var11_13 = null;
                    try (ByteArrayInputStream trustStore = new ByteArrayInputStream(trustStoreData);){
                        ks.load(trustStore, CommonUtils.isEmpty((String)trustStorePassword) ? null : trustStorePassword.toCharArray());
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(ks);
                    sslContext.init(null, tmf.getTrustManagers(), new SecureRandom());
                } else if (!CommonUtils.isEmpty((String)clientCert) && !CommonUtils.isEmpty((String)clientKey)) {
                    SSLHandlerTrustStoreImpl.initializeTrustStore((DBRProgressMonitor)monitor, (DBPDataSource)this.getDataSource(), (DBWHandlerConfiguration)sslConfig);
                    sslContext = SSLHandlerTrustStoreImpl.createTrustStoreSslContext((DBPDataSource)this.getDataSource(), (DBWHandlerConfiguration)sslConfig);
                } else {
                    builder.withSslContext(null);
                    return;
                }
                this.configureSslWithOptions(builder, sslContext);
            }
            catch (Throwable e) {
                throw new DBException("Error configuring SSL client using trust store", e);
            }
        }
    }

    protected void configureSslWithOptions(CqlSessionBuilder builder, SSLContext sslContext) throws SSLException {
        builder.withSslContext(sslContext);
    }

    @NotNull
    public CqlSession getCQLSession() {
        return this.cqlSession;
    }

    public KeyspaceCache getKeyspaceCache() {
        return this.keyspaceCache;
    }

    @Association
    public Collection<CasKeyspace> getKeyspaces() {
        return this.keyspaceCache.getCachedObjects();
    }

    public CasKeyspace getKeyspace(String name) {
        return (CasKeyspace)this.keyspaceCache.getCachedObject(name);
    }

    @Association
    public Collection<CasHost> getHosts(@NotNull DBRProgressMonitor monitor) {
        if (this.hosts == null) {
            monitor.beginTask("Load cluster hosts", 1);
            try {
                this.hosts = new ArrayList<CasHost>();
                Set allHosts = this.cqlSession.getMetadata().getNodes().entrySet();
                for (Map.Entry host : allHosts) {
                    this.hosts.add(new CasHost(this, (Node)host.getValue()));
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
        return this.hosts;
    }

    @Association
    public Collection<CasRole> getRoles(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.roles == null) {
            monitor.beginTask("Load cluster roles", 1);
            try {
                block34: {
                    this.roles = new ArrayList<CasRole>();
                    try {
                        Throwable throwable = null;
                        Object var3_5 = null;
                        try (CasSession session = (CasSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load roles");){
                            Throwable throwable2 = null;
                            Object var6_10 = null;
                            try (DBCStatement dbStat = session.prepareStatement(DBCStatementType.QUERY, "select role, is_superuser as super, can_login as login from system_auth.roles", true, false, false);){
                                if (!dbStat.executeStatement()) break block34;
                                Throwable throwable3 = null;
                                Object var9_15 = null;
                                try (DBCResultSet dbResults = dbStat.openResultSet();){
                                    while (dbResults.nextRow()) {
                                        String name = CommonUtils.toString((Object)dbResults.getAttributeValue("role"));
                                        boolean isSuper = CommonUtils.toBoolean((Object)dbResults.getAttributeValue("super"));
                                        boolean canLogin = CommonUtils.toBoolean((Object)dbResults.getAttributeValue("login"));
                                        this.roles.add(new CasRole(this, name, isSuper, canLogin, Collections.emptyMap()));
                                    }
                                }
                                catch (Throwable throwable4) {
                                    if (throwable3 == null) {
                                        throwable3 = throwable4;
                                    } else if (throwable3 != throwable4) {
                                        throwable3.addSuppressed(throwable4);
                                    }
                                    throw throwable3;
                                }
                            }
                            catch (Throwable throwable5) {
                                if (throwable2 == null) {
                                    throwable2 = throwable5;
                                } else if (throwable2 != throwable5) {
                                    throwable2.addSuppressed(throwable5);
                                }
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable6) {
                            if (throwable == null) {
                                throwable = throwable6;
                            } else if (throwable != throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                            throw throwable;
                        }
                    }
                    catch (DBCException e) {
                        throw new DBException("Error reading roles", (Throwable)e);
                    }
                }
                monitor.worked(1);
            }
            finally {
                monitor.done();
            }
        }
        return this.roles;
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return this.info;
    }

    public Object getDataSourceFeature(String featureId) {
        return null;
    }

    @NotNull
    public CasExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        CasExecutionContext context = this.createExecutionContext(purpose, initFrom instanceof CasExecutionContext ? ((CasExecutionContext)initFrom).getSelectedKeyspace() : this.getDefaultKeyspaceName());
        context.connect(monitor);
        return context;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.keyspaceCache.getAllObjects(monitor, this);
        this.info = new CasDataSourceInfo(this.cqlSession.getMetadata());
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.keyspaceCache.clearCache();
        this.shutdown(monitor);
        this.initializeCluster(monitor);
        this.initialize(monitor);
        return this;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new CasStructureAssistant(this));
        }
        return null;
    }

    public String getObjectTypeTerm(String path, String objectType, boolean multiple) {
        Object term = null;
        if ("cluster".equals(objectType)) {
            term = "Cluster";
        } else if ("keypace".equals(objectType)) {
            term = "Keyspace";
        }
        if (term != null && multiple) {
            term = (String)term + "s";
        }
        return term;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(@NotNull DBRProgressMonitor monitor) {
        super.shutdown(monitor);
        CasDataSource casDataSource = this;
        synchronized (casDataSource) {
            try {
                this.cqlSession.close();
            }
            catch (Exception e) {
                log.error((Object)"Error shutdown cluster connections", (Throwable)e);
            }
        }
    }

    @NotNull
    public SQLDialect getSQLDialect() {
        return CasCQLDialect.INSTANCE;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getKeyspaces();
    }

    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getKeyspace(childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return CasKeyspace.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int typeID) {
        return CasUtils.getDataKind((DataType)new PrimitiveType(typeID));
    }

    @Nullable
    public CasDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        return this.typeMap.get(typeFullName);
    }

    @NotNull
    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return new ArrayList<CasDataType>(this.typeMap.values());
    }

    @Nullable
    public CasDataType getLocalDataType(String typeName) {
        return this.typeMap.get(typeName);
    }

    @Nullable
    public DBSDataType getLocalDataType(int typeID) {
        for (CasDataType dt : this.typeMap.values()) {
            if (dt.getTypeID() != typeID) continue;
            return dt;
        }
        return null;
    }

    @NotNull
    public String getDefaultDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return DataTypes.BOOLEAN.toString();
            }
            case NUMERIC: {
                return DataTypes.INT.toString();
            }
            case DATETIME: {
                return DataTypes.TIMESTAMP.toString();
            }
            case BINARY: 
            case CONTENT: {
                return DataTypes.BLOB.toString();
            }
        }
        return DataTypes.ASCII.toString();
    }

    public synchronized CasTupleType getCachedTupleType(TupleType type) {
        CasTupleType res = this.tupleTypeCache.get(type);
        if (res == null) {
            res = new CasTupleType(this, type);
            this.tupleTypeCache.put(type, res);
        }
        return res;
    }

    @NotNull
    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        return DBPErrorAssistant.ErrorType.NORMAL;
    }

    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        Matcher matcher;
        String message = error.getMessage();
        if (!CommonUtils.isEmpty((String)message) && (matcher = ERROR_POSITION_PATTERN.matcher(message)).find()) {
            DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
            pos.line = Integer.parseInt(matcher.group(1)) - 1;
            pos.position = Integer.parseInt(matcher.group(2)) - 1;
            return new DBPErrorAssistant.ErrorPosition[]{pos};
        }
        return null;
    }

    public synchronized CasPrivilege getPrivilege(String permission) {
        CasPrivilege privilege = this.privilegeMap.get(permission);
        if (privilege == null) {
            privilege = new CasPrivilege(this, permission);
            this.privilegeMap.put(permission, privilege);
        }
        return privilege;
    }

    static class KeyspaceCache
    extends BasicObjectCache<CasDataSource, CasKeyspace> {
        KeyspaceCache() {
        }

        @NotNull
        public List<CasKeyspace> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CasDataSource dataSource) throws DBException {
            if (!this.isFullyCached()) {
                ArrayList<CasKeyspace> keyspaces = new ArrayList<CasKeyspace>();
                Metadata metadata = dataSource.getCQLSession().getMetadata();
                Map ksList = metadata.getKeyspaces();
                if (ksList != null) {
                    for (Map.Entry ks : ksList.entrySet()) {
                        CasKeyspace keyspace = new CasKeyspace(dataSource, (KeyspaceMetadata)ks.getValue());
                        keyspaces.add(keyspace);
                    }
                    keyspaces.sort(DBUtils.nameComparator());
                }
                this.setCache(keyspaces);
            }
            return this.getCachedObjects();
        }
    }
}

