/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.sql;

import com.azure.resourcemanager.sql.SqlServerManager;
import com.azure.resourcemanager.sql.models.SqlServer;
import com.dbeaver.cloud.azure.AzureCloudAbstractInstance;
import com.dbeaver.cloud.azure.AzureCloudService;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.util.List;
import java.util.stream.Collectors;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class AzureCloudSQLServerInstance
extends AzureCloudAbstractInstance {
    private final SqlServer instance;

    private AzureCloudSQLServerInstance(@NotNull AzureCloudSession session, @NotNull SqlServer instance) {
        super(session, new AzureCloudZone(instance.region()));
        this.instance = instance;
    }

    @NotNull
    public static List<AzureCloudAbstractInstance> list(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session) throws DBException {
        AuthModelAzureCredentials credentials = session.getCredentials();
        SqlServerManager manager = (SqlServerManager)credentials.authenticateWithToken(monitor, (AuthModelAzureCredentials.AzureScopes)AuthModelAzureCredentials.Resource.MANAGEMENT, SqlServerManager::authenticate);
        return manager.sqlServers().list().stream().map(server -> new AzureCloudSQLServerInstance(session, (SqlServer)server)).collect(Collectors.toList());
    }

    public static AzureCloudAbstractInstance get(@NotNull DBRProgressMonitor monitor, @NotNull AzureCloudSession session, @NotNull String instanceID) throws DBException {
        AuthModelAzureCredentials credentials = session.getCredentials();
        SqlServerManager manager = (SqlServerManager)credentials.authenticateWithToken(monitor, (AuthModelAzureCredentials.AzureScopes)AuthModelAzureCredentials.Resource.MANAGEMENT, SqlServerManager::authenticate);
        SqlServer instance = (SqlServer)manager.sqlServers().getById(instanceID);
        return instance == null ? null : new AzureCloudSQLServerInstance(session, instance);
    }

    @Nullable
    public String getInstanceEndpoint() {
        return this.instance.fullyQualifiedDomainName();
    }

    @NotNull
    public String getNodeId() {
        return this.instance.id();
    }

    @NotNull
    public String getNodeName() {
        return this.instance.name();
    }

    @NotNull
    public String getCloudResourceId() {
        return this.instance.id();
    }

    @Override
    protected void setDataSourceConfiguration(@NotNull DBPConnectionConfiguration configuration) {
        configuration.setHostName(this.instance.fullyQualifiedDomainName());
        configuration.setHostPort("1433");
        configuration.setAuthModelId("azure_ad_sqlserver");
    }

    @Override
    @NotNull
    protected AzureCloudService getCloudService() {
        return AzureCloudService.SQLSERVER;
    }
}

