/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.auth;

import com.dbeaver.cloud.azure.AzureCloud;
import com.dbeaver.cloud.azure.AzureCloudConfiguration;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudUtils;
import com.dbeaver.cloud.impl.AbstractCloudSessionProvider;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.model.auth.SMAuthUtils;
import com.dbeaver.net.auth.azure.AuthModelAzureCredentials;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.access.DBAAuthCredentials;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public class AzureLocalSessionProvider
extends AbstractCloudSessionProvider<AzureCloud, AuthModelAzureCredentials> {
    @Nullable
    public CPCloudSession<?> openSession(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext context, @NotNull SMSession mainSession, @NotNull AzureCloud cloud) throws DBException {
        AzureCloudConfiguration configuration = (AzureCloudConfiguration)cloud.getCloudConfiguration();
        AuthModelAzureCredentials credentials = configuration.getDefaultCredentials();
        if (!this.updateCredentialsFromSession(mainSession, credentials)) {
            credentials = (AuthModelAzureCredentials)this.updateCredentialsFromService((CPCloud)cloud, (DBAAuthCredentials)credentials);
        }
        return new AzureCloudSession(mainSession, context, cloud, credentials);
    }

    public boolean updateCredentialsFromSession(@NotNull SMSession mainSession, @NotNull AuthModelAzureCredentials credentials) {
        Map objectMap;
        if (DBWorkbench.isDistributed() && CommonUtils.isEmpty((String)credentials.getClientSecret()) && !CommonUtils.isEmpty((Map)(objectMap = SMAuthUtils.getCredentialsFromSession((SMSession)mainSession, (String)"azure")))) {
            AzureCloudUtils.updateCredentialsFromSessionData(objectMap, credentials);
            return true;
        }
        return false;
    }
}

