/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure;

import com.dbeaver.cloud.azure.AzureCloud;
import com.dbeaver.cloud.azure.AzureCloudAbstractInstance;
import com.dbeaver.cloud.azure.AzureCloudExplorer;
import com.dbeaver.cloud.azure.AzureCloudService;
import com.dbeaver.cloud.azure.AzureCloudSession;
import com.dbeaver.cloud.azure.AzureCloudZone;
import com.dbeaver.cloud.model.services.CPDatabaseFolder;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.DataSourceOriginCloud;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.DBPObject;
import org.jkiss.dbeaver.model.access.DBACredentialsProvider;
import org.jkiss.dbeaver.model.auth.SMAuthSpace;
import org.jkiss.dbeaver.model.auth.SMSession;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AzureCloudDataSourceOrigin
extends DataSourceOriginCloud<AzureCloud, AzureCloudZone>
implements DBACredentialsProvider {
    private static final Log log = Log.getLog(AzureCloudDataSourceOrigin.class);

    public AzureCloudDataSourceOrigin(@NotNull CloudProviderDescriptor cloudProvider, @NotNull Map<String, Object> configuration, @Nullable DBPExternalConfiguration externalConfiguration) {
        super(cloudProvider, configuration, externalConfiguration);
    }

    public String getResourceId() {
        return CommonUtils.toString(this.getDataSourceConfiguration().get("azure-resource"), null);
    }

    @Nullable
    public DBPObject getObjectDetails(@NotNull DBRProgressMonitor monitor, @NotNull SMSessionContext sessionContext, @NotNull DBPDataSourceContainer dataSource) throws DBException {
        AzureCloudService service = AzureCloudService.getServiceByDriver(dataSource.getDriver());
        if (service == null) {
            log.error((Object)("Cannot detect GCP service for driver " + dataSource.getDriver().getFullName()));
            return null;
        }
        AzureCloudAbstractInstance instance = this.getDatabaseInstance(monitor, sessionContext, service);
        if (instance == null) {
            log.error((Object)(service.getId() + " instance '" + this.getResourceId() + "' not found"));
        }
        return instance;
    }

    public boolean provideAuthParameters(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull DBPConnectionConfiguration configuration) throws DBException {
        SMSession session = container.getProject().getSessionContext().getSpaceSession(monitor, (SMAuthSpace)this.getCloud(), true);
        if (session instanceof AzureCloudSession) {
            return ((AzureCloudSession)session).provideAuthParameters(monitor, container, configuration);
        }
        return false;
    }

    @NotNull
    public String getAuthContextType() {
        return "azure";
    }

    public AzureCloudAbstractInstance getDatabaseInstance(DBRProgressMonitor monitor, SMSessionContext sessionContext, AzureCloudService service) throws DBException {
        AzureCloud cloud = (AzureCloud)this.getCloud();
        SMSession cloudSession = sessionContext.getSpaceSession(monitor, (SMAuthSpace)cloud, true);
        if (cloudSession instanceof AzureCloudSession) {
            AzureCloudSession as = (AzureCloudSession)cloudSession;
            AzureCloudExplorer cloudExplorer = cloud.createExplorer(monitor, as);
            return cloudExplorer.getDatabaseInstance(monitor, service.getId(), (CPDatabaseFolder)null, (AzureCloudZone)this.getZone(), this.getResourceId());
        }
        throw new DBException("GCP cloud session not found");
    }
}

