/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.azure.storage;

import com.azure.core.credential.TokenCredential;
import com.azure.core.management.profile.AzureProfile;
import com.azure.resourcemanager.storage.models.BlobContainer;
import com.azure.resourcemanager.storage.models.StorageAccount;
import com.azure.storage.blob.nio.AzureFileSystemProvider;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.dbeaver.cloud.azure.AzureCloudConfiguration;
import com.dbeaver.cloud.azure.storage.AZBFileSystem;
import com.dbeaver.cloud.model.CPCloudFileSystemRoot;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.fs.DBFUtils;
import org.jkiss.dbeaver.model.fs.DBFVirtualFileSystem;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class AZBFileSystemContainer
implements CPCloudFileSystemRoot {
    private final AZBFileSystem fs;
    private final StorageAccount account;
    private final BlobContainer container;
    private Path bucketPath;
    private transient TokenCredential tokenCredentials;
    private transient AzureProfile azureProfile;

    public AZBFileSystemContainer(@NotNull AZBFileSystem fs, @NotNull StorageAccount account, @NotNull BlobContainer container) {
        this.fs = fs;
        this.account = account;
        this.container = container;
    }

    @NotNull
    public String getName() {
        return this.container.name();
    }

    @NotNull
    public DBFVirtualFileSystem getFileSystem() {
        return this.fs;
    }

    @NotNull
    public String getRootId() {
        return this.container.name();
    }

    public DBPImage getRootIcon() {
        return null;
    }

    @NotNull
    public Path getRootPath(DBRProgressMonitor monitor) throws DBException {
        if (this.bucketPath != null) {
            return this.bucketPath;
        }
        try {
            FileSystem azbFS = this.createFileSystem(monitor);
            this.bucketPath = azbFS.getRootDirectories().iterator().next();
            DBFUtils.mapFileSystem((FileSystem)azbFS, (String)this.fs.getId());
            return this.bucketPath;
        }
        catch (Throwable e) {
            throw new DBException("Error resolving Azure container FS", e);
        }
    }

    @NotNull
    private FileSystem createFileSystem(DBRProgressMonitor monitor) throws URISyntaxException, IOException, DBException {
        URI rootURI = new URI("azb://?endpoint=" + this.account.endPoints().primary().blob());
        String storageAccountKey = ((AzureCloudConfiguration)this.fs.getCloud().getCloudConfiguration()).getStorageAccountKey();
        if (CommonUtils.isEmpty((String)storageAccountKey)) {
            throw new DBException("Storage account key is missing");
        }
        StorageSharedKeyCredential cred = new StorageSharedKeyCredential(this.account.name(), storageAccountKey);
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        config.put("AzureStorageSharedKeyCredential", cred);
        config.put("AzureStorageFileStores", this.container.name());
        FileSystem azbFS = new AzureFileSystemProvider().newFileSystem(rootURI, config);
        return azbFS;
    }

    public void close() throws IOException {
        if (this.bucketPath != null) {
            DBFUtils.mapFileSystem((FileSystem)this.bucketPath.getFileSystem(), null);
            this.bucketPath = null;
        }
    }
}

