/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.ksql.api.client.impl;

import io.confluent.ksql.api.client.Client;
import io.confluent.ksql.api.client.impl.ClientImpl;
import io.vertx.core.http.HttpMethod;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class HttpRequestImpl
implements Client.HttpRequest {
    private final Map<String, Object> payloadAsMap = new HashMap<String, Object>();
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final String path;
    private final HttpMethod method;
    private final Client client;
    private String propertiesKey = "properties";

    public HttpRequestImpl(String method, String path, Client client) {
        this.path = Objects.requireNonNull(path, "Path may not be null");
        this.method = HttpMethod.valueOf((String)Objects.requireNonNull(method, "HTTP method may not be null"));
        this.client = Objects.requireNonNull(client, "Client may not be null");
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String method() {
        return this.method.name();
    }

    @Override
    public Map<String, Object> payload() {
        return new HashMap<String, Object>(this.payloadAsMap);
    }

    @Override
    public Client.HttpRequest payload(Map<String, Object> payload) {
        Objects.requireNonNull(payload, "Payload may not be null");
        payload.forEach(this::payload);
        return this;
    }

    @Override
    public Client.HttpRequest payload(String key, Object value) {
        Objects.requireNonNull(key, "Payload key may not be null");
        Objects.requireNonNull(value, "Payload value may not be null");
        this.payloadAsMap.put(key, value);
        return this;
    }

    @Override
    public Map<String, Object> properties() {
        return new HashMap<String, Object>(this.properties);
    }

    @Override
    public Client.HttpRequest properties(Map<String, Object> properties) {
        Objects.requireNonNull(properties, "Properties map may not be null");
        properties.forEach(this::property);
        return this;
    }

    @Override
    public Client.HttpRequest property(String key, Object value) {
        Objects.requireNonNull(key, "Property key may not be null");
        Objects.requireNonNull(value, "Property value may not be null");
        this.properties.put(key, value);
        return this;
    }

    @Override
    public Client.HttpRequest propertiesKey(String propertiesKey) {
        this.propertiesKey = propertiesKey;
        return this;
    }

    @Override
    public String propertiesKey() {
        return this.propertiesKey;
    }

    Map<String, Object> buildPayload() {
        Map<String, Object> payload = this.payload();
        payload.put(this.propertiesKey(), this.properties());
        return payload;
    }

    @Override
    public CompletableFuture<Client.HttpResponse> send() {
        return ((ClientImpl)this.client).send(this.method, this.path, this.buildPayload());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpRequestImpl that = (HttpRequestImpl)o;
        return Objects.equals(this.payloadAsMap, that.payloadAsMap) && Objects.equals(this.properties, that.properties) && Objects.equals(this.path, that.path) && Objects.equals(this.method, that.method);
    }

    public int hashCode() {
        return Objects.hash(this.payloadAsMap, this.path, this.method, this.properties);
    }
}

