/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.model.CPCloudZone;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import com.dbeaver.cloud.registry.CloudProviderDescriptor;
import com.dbeaver.cloud.registry.CloudProviderRegistry;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceOriginExternal;
import org.jkiss.dbeaver.model.DBPExternalConfiguration;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.utils.CommonUtils;

public abstract class DataSourceOriginCloud<CLOUD extends CPCloud<ZONE, ?>, ZONE extends CPCloudZone>
implements DBPDataSourceOriginExternal {
    private static final Log log = Log.getLog(DataSourceOriginCloud.class);
    public static final String ORIGIN_TYPE = "cloud";
    public static final String PROPERTY_CLOUD_PROVIDER = "cloud-provider";
    public static final String PROPERTY_CLOUD_ID = "cloud-id";
    public static final String PROPERTY_CLOUD_ZONE_ID = "cloud-zone-id";
    private final CloudProviderDescriptor provider;
    private final Map<String, Object> configuration;
    private final DBPExternalConfiguration externalConfiguration;

    public DataSourceOriginCloud(CloudProviderDescriptor cloudProvider, Map<String, Object> configuration, DBPExternalConfiguration externalConfiguration) {
        this.provider = cloudProvider;
        this.configuration = configuration;
        this.externalConfiguration = externalConfiguration;
    }

    public CloudProviderDescriptor getCloudProvider() {
        return this.provider;
    }

    @Nullable
    public CLOUD getCloud() throws DBException {
        String cloudId = this.getCloudId();
        return (CLOUD)CPCloudUtils.getCloud(this.provider, cloudId, this.externalConfiguration);
    }

    @Nullable
    private String getCloudId() {
        return CommonUtils.toString((Object)this.configuration.get(PROPERTY_CLOUD_ID), null);
    }

    public ZONE getZone() throws DBException {
        String zoneId;
        CLOUD cloud = this.getCloud();
        if (cloud != null && (zoneId = CommonUtils.toString((Object)this.configuration.get(PROPERTY_CLOUD_ZONE_ID), null)) != null) {
            return (ZONE)CPCloudUtils.findZone(cloud, zoneId);
        }
        return null;
    }

    public abstract String getResourceId();

    @NotNull
    public String getType() {
        return ORIGIN_TYPE;
    }

    @Nullable
    public String getSubType() {
        return this.provider.getId();
    }

    @NotNull
    public String getDisplayName() {
        try {
            CLOUD cloud = this.getCloud();
            return cloud == null ? CommonUtils.toString((Object)this.getCloudId(), (String)"Unknown") : cloud.getName();
        }
        catch (DBException e) {
            return e.getMessage();
        }
    }

    @Nullable
    public DBPImage getIcon() {
        return this.provider.getIcon();
    }

    public boolean isDynamic() {
        return true;
    }

    @NotNull
    public Map<String, Object> getDataSourceConfiguration() {
        return this.configuration;
    }

    @Nullable
    public DBPExternalConfiguration getExternalConfiguration() {
        CPCloudConfigurationProvider<?> ccp;
        if (this.externalConfiguration == null && (ccp = CloudProviderRegistry.getInstance().getConfigurationProvider(this.provider.getId())) != null) {
            try {
                Object cloud = this.getCloud();
                if (cloud != null) {
                    return new DBPExternalConfiguration(this.getCloudId(), () -> ccp.serializeCloudConfiguration(cloud.getCloudConfiguration()));
                }
            }
            catch (DBException e) {
                log.debug((Object)e);
            }
        }
        return this.externalConfiguration;
    }

    @NotNull
    public List<DBWNetworkProfile> getAvailableNetworkProfiles() {
        try {
            CLOUD cloud = this.getCloud();
            return CPCloudUtils.getCloudTunnels(cloud);
        }
        catch (DBException e) {
            log.debug((Object)e);
            return Collections.emptyList();
        }
    }

    public String toString() {
        return this.getType() + "." + this.getSubType() + ":" + this.getResourceId();
    }
}

