/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.registry;

import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudUtils;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.net.DBWNetworkProfileProvider;

public class CloudNetworkProfileProvider
implements DBWNetworkProfileProvider {
    private static final Log log = Log.getLog(CloudNetworkProfileProvider.class);
    private final DBPProject project;

    public CloudNetworkProfileProvider(DBPProject project) {
        this.project = project;
    }

    @Nullable
    public DBWNetworkProfile getNetworkProfile(String source, String name) {
        if (!source.startsWith("cloud/")) {
            return null;
        }
        String cloudId = source.substring("cloud/".length());
        try {
            CPCloud<?, ?> cloud = CPCloudUtils.getCloud(cloudId);
            return CPCloudUtils.findCloudTunnel(cloud, name);
        }
        catch (DBException e) {
            log.debug((Object)("Error loading cloud '" + cloudId + "' configuration"), (Throwable)e);
            return null;
        }
    }
}

