/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.model.navigator;

import com.dbeaver.cloud.model.navigator.DBNCloudItemNode;
import com.dbeaver.cloud.model.navigator.DBNCloudServiceNode;
import com.dbeaver.cloud.model.services.CPDatabaseCluster;
import com.dbeaver.cloud.model.services.CPDatabaseNode;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNLazyNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class DBNCloudClusterNode
extends DBNCloudItemNode
implements DBNLazyNode {
    private final CPDatabaseCluster databaseCluster;
    private DBNNode[] children;

    public DBNCloudClusterNode(DBNNode parentNode, CPDatabaseCluster cluster) {
        super(parentNode);
        this.databaseCluster = cluster;
    }

    public CPDatabaseNode getDatabaseCluster() {
        return this.databaseCluster;
    }

    @NotNull
    public String getNodeType() {
        return "databaseCluster";
    }

    @NotNull
    public String getNodeDisplayName() {
        return this.databaseCluster.getNodeName();
    }

    @Nullable
    public String getNodeDescription() {
        return this.databaseCluster.getDescription();
    }

    @Nullable
    public DBPImage getNodeIcon() {
        return this.getParentNode().getNodeIcon();
    }

    protected boolean allowsChildren() {
        return false;
    }

    @Nullable
    public DBNNode[] getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        if (this.children == null && !monitor.isForceCacheUsage()) {
            this.children = this.readClusterNodes(monitor);
        }
        return this.children;
    }

    private DBNNode[] readClusterNodes(DBRProgressMonitor monitor) throws DBException {
        CPDatabaseNode[] instances = this.databaseCluster.getClusterDatabases();
        return DBNCloudServiceNode.createDatabaseNodes(monitor, this, instances);
    }

    public boolean needsInitialization() {
        return this.children == null;
    }
}

