/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.impl;

import com.dbeaver.cloud.model.CPCloudConfiguration;
import com.dbeaver.cloud.model.CPCloudServiceAccount;
import com.dbeaver.cloud.model.CPCloudUtils;
import com.dbeaver.cloud.registry.CPCloudConfigurationProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.dbeaver.model.secret.DBSSecretSubject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractCloudConfiguration<T extends AbstractCloudConfiguration<T>>
implements CPCloudConfiguration<T>,
DBSSecretSubject {
    private static final Log log = Log.getLog(AbstractCloudConfiguration.class);
    public static final String CLOUD_OBJECT_PATH_PREFIX = "cloud/";
    private String cloudId;
    private String cloudName;
    private List<DBWNetworkProfile> tunnelProfiles = null;
    private transient List<? extends CPCloudServiceAccount> serviceAccounts;

    @Override
    @Nullable
    public String getCloudId() {
        return this.cloudId;
    }

    @Override
    public void setCloudId(@NotNull String cloudId) {
        this.cloudId = cloudId;
    }

    @Override
    @Nullable
    public String getCloudName() {
        return this.cloudName;
    }

    @Override
    public void setCloudName(@NotNull String cloudName) {
        this.cloudName = cloudName;
    }

    @Override
    public String[] getEnabledZones() {
        return new String[0];
    }

    @Override
    public boolean isCloudSettingsEqual(T configuration) {
        return CommonUtils.equalObjects((Object)this.cloudId, (Object)((AbstractCloudConfiguration)configuration).getCloudId());
    }

    @Override
    @NotNull
    public synchronized List<? extends CPCloudServiceAccount> getServiceAccounts() throws DBException {
        if (this.serviceAccounts == null) {
            CPCloudConfigurationProvider<?> cfgProvider = CPCloudUtils.getConfigurationProvider(this.getClass());
            this.serviceAccounts = cfgProvider != null ? cfgProvider.loadCloudServiceAccounts() : new ArrayList<CPCloudServiceAccount>();
        }
        return this.serviceAccounts;
    }

    @Override
    public void setServiceAccounts(List<? extends CPCloudServiceAccount> serviceAccounts) throws DBException {
        CPCloudConfigurationProvider<?> cfgProvider = CPCloudUtils.getConfigurationProvider(this.getClass());
        if (cfgProvider != null) {
            cfgProvider.saveCloudServiceAccounts(serviceAccounts);
            this.serviceAccounts = new ArrayList<CPCloudServiceAccount>(serviceAccounts);
        }
    }

    @Override
    public boolean isDefaultConfiguration() {
        return DBWorkbench.isDistributed() && !DBWorkbench.getPlatform().getApplication().isMultiuser() && this.getCloudId() != null && this.getCloudId().equals(this.getGlobalCloudId());
    }

    @Override
    public void mergeCloudSettings(T configuration) {
        this.cloudName = ((AbstractCloudConfiguration)configuration).getCloudName();
    }

    @NotNull
    public List<DBWNetworkProfile> getTunnelProfiles() {
        return this.tunnelProfiles != null ? this.tunnelProfiles : Collections.emptyList();
    }

    public void setTunnelProfiles(@NotNull List<DBWNetworkProfile> tunnelProfiles) {
        this.tunnelProfiles = tunnelProfiles;
    }

    public void processPostLoadActions() {
        if (!CommonUtils.isEmpty(this.tunnelProfiles)) {
            for (DBWNetworkProfile profile : this.tunnelProfiles) {
                profile.setSecretSubject((DBSSecretSubject)this);
            }
        }
    }

    public String getSecretSubjectId() {
        return CLOUD_OBJECT_PATH_PREFIX + this.getCloudId();
    }

    @Nullable
    public abstract String getGlobalCloudId();

    public String toString() {
        return this.getCloudName() + "(" + this.getCloudId() + ")";
    }
}

