/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.cloud.impl;

import com.dbeaver.cloud.impl.AbstractCloudConfiguration;
import com.dbeaver.cloud.model.CPCloud;
import com.dbeaver.cloud.model.CPCloudProvider;
import com.dbeaver.cloud.model.CPCloudSession;
import com.dbeaver.cloud.model.CPCloudTunnelManager;
import com.dbeaver.cloud.model.CPCloudZone;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.net.DBWNetworkProfile;
import org.jkiss.utils.CommonUtils;

public abstract class AbstractCloud<PROVIDER extends CPCloudProvider, CONFIG extends AbstractCloudConfiguration<CONFIG>, ZONE extends CPCloudZone, SESSION extends CPCloudSession<ZONE>>
implements CPCloud<ZONE, SESSION>,
CPCloudTunnelManager {
    private final PROVIDER provider;
    private final CONFIG configuration;

    protected AbstractCloud(PROVIDER provider, CONFIG configuration) {
        this.provider = provider;
        this.configuration = configuration;
    }

    public PROVIDER getProvider() {
        return this.provider;
    }

    @NotNull
    public CONFIG getCloudConfiguration() {
        return this.configuration;
    }

    @Override
    @NotNull
    public String getCloudId() {
        return CommonUtils.notEmpty((String)((AbstractCloudConfiguration)this.configuration).getCloudId());
    }

    @NotNull
    public String getName() {
        return CommonUtils.notEmpty((String)CommonUtils.toString((Object)((AbstractCloudConfiguration)this.configuration).getCloudName(), (String)((AbstractCloudConfiguration)this.configuration).getCloudId()));
    }

    @Override
    public boolean isDatabaseServiceSupported(String serviceId) {
        return true;
    }

    @Override
    public boolean isTunnelSupported() {
        return true;
    }

    @Override
    public List<DBWNetworkProfile> getTunnelProfiles() {
        return ((AbstractCloudConfiguration)this.configuration).getTunnelProfiles();
    }

    @Override
    public void setTunnelProfiles(List<DBWNetworkProfile> profiles) {
        ((AbstractCloudConfiguration)this.configuration).setTunnelProfiles(profiles);
    }

    public String toString() {
        return this.getClass().getSimpleName() + " (" + ((AbstractCloudConfiguration)this.configuration).getCloudId() + ")";
    }

    public boolean equals(Object obj) {
        return obj instanceof AbstractCloud && ((AbstractCloud)obj).getCloudId().equals(this.getCloudId());
    }
}

