/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.workspace;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.impl.preferences.AbstractUserPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.security.SMController;
import org.jkiss.utils.CommonUtils;

public class RemoteUserPreferenceStore
extends AbstractUserPreferenceStore {
    private static final Log log = Log.getLog(RemoteUserPreferenceStore.class);
    private final Map<String, Object> serverPreferences = new HashMap<String, Object>();
    private SMController smController;
    private boolean changed = false;
    private boolean forceUseLocalPreferenceStore = false;

    public RemoteUserPreferenceStore(@NotNull DBPPreferenceStore parentStore) {
        super(parentStore);
    }

    public void setForceUseLocalPreferenceStore(boolean forceUseLocalPreferenceStore) {
        this.forceUseLocalPreferenceStore = forceUseLocalPreferenceStore;
    }

    public void updateServerPreferences(@NotNull Map<String, Object> newServerPreferences) {
        this.serverPreferences.clear();
        this.serverPreferences.putAll(newServerPreferences);
    }

    public void setSmController(SMController smController) {
        this.smController = smController;
    }

    public boolean contains(@NotNull String name) {
        return this.serverPreferences.containsKey(name) || this.userPreferences.containsKey(name) || this.parentStore.contains(name);
    }

    public String getString(@NotNull String name) {
        if (this.forceUseLocalPreferenceStore) {
            return this.parentStore.getString(name);
        }
        Object value = this.userPreferences.get(name);
        return value == null ? this.getDefaultString(name) : value.toString();
    }

    @NotNull
    public String getDefaultString(@NotNull String name) {
        if (this.forceUseLocalPreferenceStore) {
            return this.parentStore.getDefaultString(name);
        }
        Object value = this.serverPreferences.get(name);
        if (value == null) {
            value = this.parentStore.getDefaultString(name);
        }
        return value == null ? "" : value.toString();
    }

    public boolean isDefault(@NotNull String name) {
        return !this.userPreferences.containsKey(name) && this.serverPreferences.containsKey(name) || this.parentStore.isDefault(name);
    }

    public boolean needsSaving() {
        return this.changed;
    }

    public void setToDefault(@NotNull String name) {
        if (this.userPreferences.containsKey(name)) {
            this.userPreferences.put(name, null);
            this.changed = true;
        }
        this.parentStore.setToDefault(name);
    }

    protected void setUserPreference(String name, Object value) {
        if (this.forceUseLocalPreferenceStore) {
            this.parentStore.setValue(name, CommonUtils.toString((Object)value));
        }
        if (!this.getDefaultString(name).equals(CommonUtils.toString((Object)value))) {
            this.userPreferences.put(name, value == null ? null : String.valueOf(value));
            this.changed = true;
        } else if (this.userPreferences.containsKey(name)) {
            this.userPreferences.put(name, null);
            this.changed = true;
        }
    }

    public void save() throws IOException {
        if (this.forceUseLocalPreferenceStore) {
            log.warn((Object)"Local storage is forcible used preferences will be saved in local files.");
            this.parentStore.save();
            return;
        }
        if (!this.changed) {
            return;
        }
        if (this.smController == null) {
            throw new IOException("Not authorized to perform this action");
        }
        try {
            this.smController.setCurrentUserParameters(this.userPreferences);
            this.changed = false;
        }
        catch (DBException e) {
            throw new IOException("Error during saving preferences: " + e.getMessage(), e);
        }
    }
}

