/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.workspace;

import com.dbeaver.model.rm.DatasourceRegistryRMPRO;
import com.dbeaver.remote.client.rm.RMClient;
import com.dbeaver.remote.filesystem.RemoteFileStore;
import com.dbeaver.remote.workspace.DesktopWorkspaceRemote;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPDataSourceRegistry;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.auth.SMSessionContext;
import org.jkiss.dbeaver.model.impl.app.BaseWorkspaceImpl;
import org.jkiss.dbeaver.model.rcp.DesktopProjectImpl;
import org.jkiss.dbeaver.model.rm.RMController;
import org.jkiss.dbeaver.model.rm.RMControllerProvider;
import org.jkiss.dbeaver.model.rm.RMObject;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMProjectInfo;
import org.jkiss.dbeaver.model.rm.RMResource;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.security.user.SMAuthPermissions;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.utils.ArrayUtils;
import org.jkiss.utils.CommonUtils;

public class RemoteProjectImpl
extends DesktopProjectImpl
implements RMControllerProvider {
    private static final Log log = Log.getLog(RemoteProjectImpl.class);
    public static final String REMOTE_FOLDER = ".remote";
    private final RMClient rmClient;
    private final String projectId;
    protected RMProject rmProject;
    private boolean projectLoaded;
    private boolean initialized;
    private boolean cacheLoaded;

    public RemoteProjectImpl(@NotNull DesktopWorkspaceRemote workspace, @NotNull IProject eclipseProject, @Nullable SMSessionContext sessionContext) {
        super((BaseWorkspaceImpl)workspace, eclipseProject, sessionContext);
        this.projectId = eclipseProject.getLocation().lastSegment();
        this.rmClient = new RMClient(this.getWorkspace().getRmClientConfiguration());
    }

    @NotNull
    public String getId() {
        return this.projectId;
    }

    public boolean isUseSecretStorage() {
        return false;
    }

    public boolean isPrivateProject() {
        SMAuthPermissions authPermissions = this.getWorkspace().getWorkspaceAuthInfo().getAuthPermissions();
        return this.projectId.startsWith("u_") && authPermissions != null && this.projectId.substring(2).equals(authPermissions.getUserId());
    }

    public boolean isGlobalProject() {
        return this.projectId.startsWith("g_");
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    void initializeRemoteProject() throws DBException {
        IProject eclipseProject = this.getEclipseProject();
        if (eclipseProject == null) {
            throw new DBException("Eclipse project required");
        }
        try {
            IFolder remoteFolder = eclipseProject.getFolder(REMOTE_FOLDER);
            if (!remoteFolder.exists()) {
                URI remoteURI = new URI("dbrm", null, "/", remoteFolder.getLocation().toString(), null);
                remoteFolder.createLink(remoteURI, 272, (IProgressMonitor)new NullProgressMonitor());
            }
            this.initialized = true;
        }
        catch (Exception e) {
            throw new DBException("Error initializing remote project " + eclipseProject.getName(), (Throwable)e);
        }
    }

    public void ensureOpen() throws IllegalStateException {
        super.ensureOpen();
        if (this.initialized && !this.cacheLoaded) {
            final IProject eclipseProject = this.getEclipseProject();
            if (eclipseProject != null) {
                new AbstractJob("Refresh project"){

                    protected IStatus run(DBRProgressMonitor monitor) {
                        IFolder remoteFolder = eclipseProject.getFolder(RemoteProjectImpl.REMOTE_FOLDER);
                        try {
                            remoteFolder.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (CoreException e) {
                            throw new IllegalStateException(e);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
            this.cacheLoaded = true;
        }
        if (!this.initialized) {
            try {
                this.initializeRemoteProject();
            }
            catch (DBException e) {
                log.error((Object)("Error initializing remote project '" + this.getDisplayName() + "'"), (Throwable)e);
            }
        }
    }

    @Nullable
    public IContainer getRootResource() {
        return this.getEclipseProject().getFolder(REMOTE_FOLDER);
    }

    private RMResource findRemoteResource(String resourcePath) {
        return this.findRemoteResource(resourcePath, false);
    }

    @Nullable
    private RMResource findRemoteResource(@NotNull String resourcePath, boolean createFileIfNotExists) {
        RMResource resource;
        IPath resourceLocation;
        block7: {
            resourceLocation = Path.fromOSString((String)resourcePath);
            try {
                RMObject object = this.getResourceFromCache(resourceLocation);
                if (object == null) {
                    resource = null;
                    break block7;
                }
                if (object instanceof RMResource) {
                    RMResource r;
                    resource = r = (RMResource)object;
                    break block7;
                }
                throw new IllegalStateException("Remote resource expected at '" + resourcePath + "' in cache but found " + String.valueOf(object));
            }
            catch (DBException e) {
                throw new IllegalStateException("Error reading resource '" + resourcePath + "' from cache", e);
            }
        }
        if (createFileIfNotExists && resource == null) {
            try {
                resource = this.addResourceToCache(resourceLocation, false);
            }
            catch (DBException e) {
                throw new IllegalStateException("Error adding resource '" + resourcePath + "' to cache", e);
            }
        }
        return resource;
    }

    @Nullable
    public Object getResourceProperty(@NotNull String resourcePath, @NotNull String propName) {
        RMResource resource = this.findRemoteResource(resourcePath);
        if (resource != null) {
            Map properties = resource.getProperties();
            if (properties != null) {
                return properties.get(propName);
            }
            return null;
        }
        return null;
    }

    @Nullable
    public Map<String, Object> getResourceProperties(@NotNull String resourcePath) {
        Map properties;
        RMResource resource = this.findRemoteResource(resourcePath);
        if (resource != null && (properties = resource.getProperties()) != null) {
            return Collections.unmodifiableMap(properties);
        }
        return Collections.emptyMap();
    }

    public void setResourceProperties(@NotNull String resourcePath, @NotNull Map<String, Object> newProps) {
        try {
            this.rmClient.setResourceProperties(this.getId(), resourcePath, newProps);
        }
        catch (DBException e) {
            throw new IllegalStateException("Error updating properties on resource '" + resourcePath + "'", e);
        }
        RMResource resource = this.findRemoteResource(resourcePath, true);
        if (resource != null) {
            resource.setProperties(new LinkedHashMap<String, Object>(newProps));
        }
    }

    public void setResourceProperty(@NotNull String resourcePath, @NotNull String propName, @Nullable Object propValue) {
        if (CommonUtils.equalObjects((Object)propValue, (Object)this.getResourceProperty(resourcePath, propName))) {
            return;
        }
        try {
            this.rmClient.setResourceProperty(this.getId(), resourcePath, propName, propValue);
        }
        catch (DBException e) {
            throw new IllegalStateException("Error updating property '" + propName + "' on resource '" + resourcePath + "'", e);
        }
        RMResource resource = this.findRemoteResource(resourcePath, true);
        if (resource != null) {
            LinkedHashMap<String, Object> properties = resource.getProperties();
            if (CommonUtils.isEmpty((Map)properties)) {
                properties = new LinkedHashMap<String, Object>();
            }
            if (propValue == null) {
                properties.remove(propName);
            } else {
                properties.put(propName, propValue);
            }
            resource.setProperties(properties);
        }
    }

    @NotNull
    public String getResourcePath(@NotNull IResource resource) {
        return resource.getFullPath().removeFirstSegments(2).toString();
    }

    @NotNull
    protected DBPDataSourceRegistry createDataSourceRegistry() {
        return new DatasourceRegistryRMPRO((DBPProject)this, (RMController)this.rmClient, DBWorkbench.getPlatform().getPreferenceStore());
    }

    @NotNull
    public String[] findResources(@NotNull Map<String, ?> properties) throws DBException {
        this.readCacheIfNeeded();
        ArrayList<String> resources = new ArrayList<String>();
        if (this.rmProject.getChildren() != null) {
            RMResource[] rMResourceArray = this.rmProject.getChildren();
            int n = rMResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                RMResource root = rMResourceArray[n2];
                this.findResourcesByProperties(new RMResource[0], root, resources, properties);
                ++n2;
            }
        }
        return resources.toArray(new String[0]);
    }

    private void findResourcesByProperties(RMResource[] path, RMResource object, List<String> resources, Map<String, ?> properties) {
        Map resProps = object.getProperties();
        if (resProps != null) {
            for (Map.Entry<String, ?> pe : properties.entrySet()) {
                if (!CommonUtils.equalObjects(resProps.get(pe.getKey()), pe.getValue())) continue;
                resources.add(RemoteProjectImpl.getResourcePath(path, object));
                break;
            }
        }
        if (object.getChildren() != null) {
            RMResource[] newPath = (RMResource[])ArrayUtils.add(RMResource.class, (Object[])path, (Object)object);
            RMResource[] rMResourceArray = object.getChildren();
            int n = rMResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                RMResource child = rMResourceArray[n2];
                this.findResourcesByProperties(newPath, child, resources, properties);
                ++n2;
            }
        }
    }

    private static String getResourcePath(RMResource[] path, RMResource resource) {
        if (path.length == 0) {
            return resource.getName();
        }
        if (path.length == 1) {
            return path[0].getName() + "/" + resource.getName();
        }
        return Arrays.stream(path).map(RMObject::getName).collect(Collectors.joining("/")) + "/" + resource.getName();
    }

    public boolean isVirtual() {
        return true;
    }

    @NotNull
    public String getName() {
        if (this.rmProject != null) {
            return this.rmProject.getName();
        }
        return super.getName();
    }

    @NotNull
    public String getDisplayName() {
        if (this.rmProject != null) {
            return this.rmProject.getDisplayName();
        }
        return super.getDisplayName();
    }

    @NotNull
    public DesktopWorkspaceRemote getWorkspace() {
        return (DesktopWorkspaceRemote)super.getWorkspace();
    }

    public RMObject getResourceFromCache(IPath path) throws DBException {
        String name;
        this.readCacheIfNeeded();
        if (path.segmentCount() == 1 && ((name = path.segment(0)).isEmpty() || name.equals("/"))) {
            return this.rmProject;
        }
        RMProject curObject = this.rmProject;
        int i = 0;
        while (i < path.segmentCount()) {
            String name2 = path.segment(i);
            if ((curObject = curObject.getChild(name2)) == null) {
                return null;
            }
            ++i;
        }
        return curObject;
    }

    public RMResource addResourceToCache(IPath path, boolean isFolder) throws DBException {
        this.readCacheIfNeeded();
        RMProject curObject = this.rmProject;
        int i = 0;
        while (i < path.segmentCount()) {
            String name = path.segment(i);
            RMResource child = curObject.getChild(name);
            if (child == null) {
                if (i == path.segmentCount() - 1) {
                    RMResource res = new RMResource(name);
                    res.setFolder(isFolder);
                    curObject.addChild(res);
                    return res;
                }
                throw new DBException("Bad resource parent path: " + String.valueOf(path));
            }
            curObject = child;
            ++i;
        }
        throw new DBException("Resource '" + String.valueOf(path) + "' already exists");
    }

    public void removeResourceFromCache(IPath path) throws DBException {
        this.readCacheIfNeeded();
        RMProject curObject = this.rmProject;
        int i = 0;
        while (i < path.segmentCount()) {
            String name = path.segment(i);
            RMResource child = curObject.getChild(name);
            if (child == null) {
                return;
            }
            if (i == path.segmentCount() - 1) {
                curObject.removeChild(child);
                break;
            }
            curObject = child;
            ++i;
        }
    }

    public void addNewResourceToCache(IPath path) throws DBException {
        this.readCacheIfNeeded();
        RMResource[] resourcePath = this.getWorkspace().getResourceController().getResourcePath(this.getId(), path.toString());
        if (resourcePath.length != path.segmentCount()) {
            throw new DBException("Bad resource '" + String.valueOf(path) + "' path (" + resourcePath.length + "<>" + path.segmentCount() + ")");
        }
        RMProject curObject = this.rmProject;
        int i = 0;
        while (i < path.segmentCount() - 1) {
            String name = path.segment(i);
            RMResource child = curObject.getChild(name);
            if (child == null) {
                child = resourcePath[i];
                curObject.addChild(child);
            }
            curObject = child;
            ++i;
        }
        curObject.addChild(resourcePath[resourcePath.length - 1]);
    }

    public void updateResourceCache(IPath path, IResource resource) throws DBException {
        this.readCacheIfNeeded();
        RMResource[] resourcePath = this.getWorkspace().getResourceController().getResourcePath(this.getId(), path.toString());
        if (resourcePath.length != path.segmentCount()) {
            throw new DBException("Bad resource '" + String.valueOf(path) + "' path (" + resourcePath.length + "<>" + path.segmentCount() + ")");
        }
        RMProject curObject = this.rmProject;
        int i = 0;
        while (i < path.segmentCount()) {
            String name = path.segment(i);
            RMResource child = curObject.getChild(name);
            if (child == null) {
                throw new DBException("Resource '" + String.valueOf(path) + "' not found in cache");
            }
            if (!resourcePath[i].isFolder()) {
                curObject.updateChild(name, resourcePath[i]);
            }
            curObject = child;
            ++i;
        }
        Workspace workspace = (Workspace)((DesktopWorkspaceRemote)DBWorkbench.getPlatform().getWorkspace()).getEclipseWorkspace();
        IFileStore parentStore = workspace.getFileSystemManager().getStore((IResource)resource.getParent());
        if (parentStore instanceof RemoteFileStore) {
            ((RemoteFileStore)parentStore).removeFromCache(resource.getName());
        }
    }

    private synchronized void readCacheIfNeeded() throws DBException {
        if (this.projectLoaded) {
            return;
        }
        this.rmProject = this.getWorkspace().getResourceController().getProject(this.getId(), true, true);
        this.projectLoaded = true;
    }

    public void deleteProject(RMProject project) throws DBException {
        this.rmClient.deleteProject(project.getId());
    }

    public boolean isResourceExists(IPath path) throws DBException {
        this.readCacheIfNeeded();
        RMProject curObject = this.rmProject;
        int i = 0;
        while (i < path.segmentCount()) {
            String name = path.segment(i);
            RMResource child = curObject.getChild(name);
            if (child == null) {
                return false;
            }
            curObject = child;
            ++i;
        }
        return true;
    }

    public void deleteResource(IPath path) throws DBException {
        this.readCacheIfNeeded();
        RMProject curObject = this.rmProject;
        int i = 0;
        while (i < path.segmentCount()) {
            String name = path.segment(i);
            RMResource child = curObject.getChild(name);
            if (child == null) {
                throw new DBException("Resource '" + String.valueOf(path) + "' not found in project");
            }
            if (i == path.segmentCount() - 1) {
                this.rmClient.deleteResource(this.rmProject.getId(), path.toString(), true);
                curObject.removeChild(child);
                break;
            }
            curObject = child;
            ++i;
        }
    }

    public void updateProject(@Nullable String newName, @Nullable String description) throws DBException {
        this.readCacheIfNeeded();
        RMProject rmProject = this.getResourceController().updateProject(this.getId(), new RMProjectInfo(newName, description));
        this.updateProjectInfo(rmProject.getName(), rmProject.getDescription());
    }

    @NotNull
    public RMProject getRMProject() {
        return this.rmProject;
    }

    @NotNull
    public RMController getResourceController() {
        return this.rmClient;
    }

    public void updateProjectInfo(@Nullable String name, @Nullable String description) {
        this.rmProject.setName(CommonUtils.notEmpty((String)name));
        this.rmProject.setDescription(description);
    }
}

