/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.filesystem;

import com.dbeaver.remote.filesystem.RemoteFileSystem;
import com.dbeaver.remote.workspace.RemoteProjectImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.provider.FileInfo;
import org.eclipse.core.filesystem.provider.FileStore;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.fs.DBFRemoteFileStore;
import org.jkiss.dbeaver.model.rm.RMObject;
import org.jkiss.dbeaver.model.rm.RMProject;
import org.jkiss.dbeaver.model.rm.RMResource;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public class RemoteFileStore
extends FileStore
implements DBFRemoteFileStore {
    private static final Log log = Log.getLog(RemoteFileStore.class);
    @NotNull
    private final IFileStore rootStore;
    @NotNull
    private final IPath fullPath;
    @NotNull
    private RMObject resource;
    private Map<String, RemoteFileStore> childStores = null;
    private SoftReference<byte[]> contents;

    public RemoteFileStore(@NotNull IFileStore rootStore, @NotNull IPath fullPath, @NotNull RMObject resource) {
        this.rootStore = rootStore;
        this.fullPath = fullPath;
        this.resource = resource;
    }

    private String getRemoteProjectId() {
        return this.rootStore.getParent().getName();
    }

    public IFileInfo[] childInfos(int options, IProgressMonitor monitor) throws CoreException {
        this.validateCache();
        RMResource[] children = this.resource.getChildren();
        if (children == null) {
            return new IFileInfo[0];
        }
        IFileInfo[] infos = new IFileInfo[children.length];
        int i = 0;
        while (i < children.length) {
            RMResource resource = children[i];
            FileInfo fileInfo = new FileInfo(resource.getName());
            fileInfo.setDirectory(resource.isFolder());
            fileInfo.setExists(true);
            fileInfo.setLength(resource.getLength());
            infos[i] = fileInfo;
            ++i;
        }
        return infos;
    }

    public String[] childNames(int options, IProgressMonitor monitor) throws CoreException {
        this.validateCache();
        RMResource[] childResources = this.resource.getChildren();
        if (childResources == null) {
            return new String[0];
        }
        String[] names = new String[childResources.length];
        int i = 0;
        while (i < childResources.length) {
            names[i] = childResources[i].getName();
            ++i;
        }
        return names;
    }

    public IFileInfo fetchInfo(int options, IProgressMonitor monitor) throws CoreException {
        boolean editable;
        RMProject rmProject;
        if (this.fullPath.segmentCount() == 0) {
            FileInfo fileInfo = new FileInfo();
            fileInfo.setDirectory(true);
            fileInfo.setExists(true);
            return fileInfo;
        }
        this.validateCache();
        FileInfo fileInfo = new FileInfo(this.getName());
        fileInfo.setDirectory(this.resource.isFolder());
        fileInfo.setExists(true);
        RemoteProjectImpl remoteProject = RemoteFileSystem.getRemoteProject(this.rootStore.toURI());
        if (remoteProject != null && (rmProject = remoteProject.getRMProject()) != null && !(editable = rmProject.hasProjectPermission("project-resource-edit"))) {
            fileInfo.setAttribute(2, true);
            fileInfo.setAttribute(0x200000, true);
        }
        if (this.resource instanceof RMResource) {
            Long lastModified = ((RMResource)this.resource).getLastModified();
            if (lastModified != null) {
                fileInfo.setLastModified(lastModified.longValue());
            }
            fileInfo.setLength(((RMResource)this.resource).getLength());
        }
        return fileInfo;
    }

    public synchronized IFileStore getChild(String name) {
        try {
            this.validateCache();
        }
        catch (CoreException e) {
            log.error((Object)e);
        }
        RMResource[] children = this.resource.getChildren();
        if (children != null) {
            RemoteFileStore childStore;
            if (this.childStores == null) {
                this.childStores = new HashMap<String, RemoteFileStore>();
            }
            if ((childStore = this.childStores.get(name)) != null) {
                return childStore;
            }
            RMResource[] rMResourceArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                RMResource child = rMResourceArray[n2];
                if (child.getName().equals(name)) {
                    childStore = new RemoteFileStore(this.rootStore, this.fullPath.append(name), (RMObject)child);
                    this.childStores.put(name, childStore);
                    return childStore;
                }
                ++n2;
            }
        }
        String message = "Resource '" + name + "' not found in remote project '" + this.getRemoteProjectId() + "' at '" + String.valueOf(this.fullPath) + "'. Create new one.";
        log.debug((Object)message);
        RemoteFileStore newStore = new RemoteFileStore(this.rootStore, this.fullPath.append(name), (RMObject)new RMResource(name));
        if (this.childStores != null) {
            this.childStores.put(name, newStore);
        }
        return newStore;
    }

    public String getName() {
        return this.resource.getName();
    }

    public IFileStore getParent() {
        RMObject parentObject;
        block4: {
            if (this.resource instanceof RMProject) {
                return this.rootStore;
            }
            try {
                parentObject = this.getRemoteProject().getResourceFromCache(this.fullPath.removeLastSegments(1));
                if (parentObject != null) break block4;
                log.error((Object)("Wrong parent reference: " + String.valueOf(this.fullPath)));
                return null;
            }
            catch (DBException e) {
                log.error((Object)e);
                return null;
            }
        }
        return new RemoteFileStore(this.rootStore, this.fullPath.removeLastSegments(1), parentObject);
    }

    public InputStream openInputStream(int options, IProgressMonitor monitor) throws CoreException {
        byte[] data;
        byte[] byArray = data = this.contents == null ? null : this.contents.get();
        if (data == null) {
            try {
                RemoteProjectImpl project = this.getRemoteProject();
                data = project.getWorkspace().getResourceController().getResourceContents(project.getId(), this.fullPath.toString());
                this.contents = new SoftReference<byte[]>(data);
            }
            catch (DBException e) {
                throw new CoreException(Status.error((String)("Couldn't read file '" + this.getName() + "' contents"), (Throwable)e));
            }
        }
        return new ByteArrayInputStream(data);
    }

    public OutputStream openOutputStream(int options, IProgressMonitor monitor) throws CoreException {
        return new ByteArrayOutputStream(){
            private boolean closed;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    this.closed = true;
                    RemoteFileStore.this.saveResourceContents(this);
                }
            }
        };
    }

    private void saveResourceContents(ByteArrayOutputStream baos) throws IOException {
        try {
            IFileStore parent;
            RemoteProjectImpl project = this.getRemoteProject();
            byte[] data = baos.toByteArray();
            project.getWorkspace().getResourceController().setResourceContents(project.getId(), this.fullPath.toString(), data, project.getResourceFromCache(this.fullPath) != null);
            this.contents = new SoftReference<byte[]>(data);
            if (this.resource instanceof RMResource) {
                ((RMResource)this.resource).setLength((long)baos.size());
                ((RMResource)this.resource).setLastModified(Long.valueOf(System.currentTimeMillis()));
            }
            if ((parent = this.getParent()) instanceof RemoteFileStore) {
                ((RemoteFileStore)parent).ensureChildCached(this);
            }
        }
        catch (DBException e) {
            log.debug((Object)e);
            throw new IOException(e.getMessage(), e);
        }
    }

    public URI toURI() {
        try {
            return new URI("dbrm", null, this.fullPath.toString(), this.rootStore.toURI().toString(), null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public IFileStore mkdir(int options, IProgressMonitor monitor) throws CoreException {
        try {
            RemoteProjectImpl project = this.getRemoteProject();
            RMObject resourceFromCache = project.getResourceFromCache(this.fullPath);
            if (resourceFromCache != null) {
                if (resourceFromCache.isFolder()) {
                    return this;
                }
                throw new CoreException(Status.error((String)("Folder '" + String.valueOf(this.fullPath) + "' already exists")));
            }
            project.getWorkspace().getResourceController().createResource(project.getRMProject().getId(), this.fullPath.toString(), true);
            RMResource newFolder = new RMResource(this.getName());
            newFolder.setFolder(true);
            this.resource = project.addResourceToCache(this.fullPath, true);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)("Couldn't create folder '" + String.valueOf(this.fullPath) + "'"), (Throwable)e));
        }
        return this;
    }

    public void copy(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        super.copy(destination, options, monitor);
    }

    public void delete(int options, IProgressMonitor monitor) throws CoreException {
        if (this.resource instanceof RMProject) {
            try {
                this.getRemoteProject().deleteProject((RMProject)this.resource);
            }
            catch (Exception e) {
                throw new CoreException(Status.error((String)("Couldn't delete project '" + this.resource.getName() + "'"), (Throwable)e));
            }
        }
        try {
            RemoteProjectImpl remoteProject = this.getRemoteProject();
            if (!remoteProject.isResourceExists(this.fullPath)) {
                return;
            }
            remoteProject.deleteResource(this.fullPath);
        }
        catch (Exception e) {
            throw new CoreException(Status.error((String)("Couldn't delete resource '" + String.valueOf(this.fullPath) + "'"), (Throwable)e));
        }
    }

    public void move(IFileStore destination, int options, IProgressMonitor monitor) throws CoreException {
        if (this.resource instanceof RMResource) {
            if (!(destination instanceof RemoteFileStore)) {
                throw new CoreException(Status.error((String)"Move to non-remote file store is not supported"));
            }
            IPath targetPath = ((RemoteFileStore)destination).fullPath;
            try {
                RemoteProjectImpl project = this.getRemoteProject();
                project.getWorkspace().getResourceController().moveResource(project.getRMProject().getId(), this.fullPath.toString(), targetPath.toString());
                project.removeResourceFromCache(this.fullPath);
                RMResource rmResource = project.addResourceToCache(targetPath, this.resource.isFolder());
                RMResource thisResource = (RMResource)this.resource;
                rmResource.setLength(thisResource.getLength());
                rmResource.setLastModified(thisResource.getLastModified());
                rmResource.setProperties(thisResource.getProperties());
            }
            catch (Exception e) {
                throw new CoreException(Status.error((String)("Couldn't move resource '" + String.valueOf(this.fullPath) + "'"), (Throwable)e));
            }
        } else {
            throw new CoreException(Status.error((String)"Project rename is not supported"));
        }
    }

    public void refresh(@NotNull DBRProgressMonitor monitor) throws DBException {
        IPath relativePath = this.fullPath.makeRelative();
        if (this.resource.isFolder() || this.resource instanceof RMProject) {
            this.resource.setChildren(this.getRemoteProject().getWorkspace().getResourceController().listResources(this.getRemoteProjectId(), relativePath.toString(), null, true, true, false));
        } else {
            RMResource current = (RMResource)this.resource;
            RMResource[] resources = this.getRemoteProject().getWorkspace().getResourceController().listResources(this.getRemoteProjectId(), relativePath.removeLastSegments(1).toString(), relativePath.lastSegment(), true, true, false);
            if (resources.length == 1) {
                RMResource actual = resources[0];
                current.setProperties(actual.getProperties());
                current.setLength(actual.getLength());
                current.setLastModified(actual.getLastModified());
                current.setChanges(actual.getChanges());
            } else {
                log.error((Object)("Failed to refresh metadata for file " + String.valueOf(relativePath)));
            }
        }
    }

    private void ensureChildCached(@NotNull RemoteFileStore store) {
        Assert.isLegal((boolean)store.getParent().equals((Object)this));
        if (this.resource.getChild(store.getName()) == null && store.resource instanceof RMResource) {
            this.resource.addChild((RMResource)store.resource);
        }
        if (this.childStores == null) {
            this.childStores = new HashMap<String, RemoteFileStore>();
        }
        this.childStores.putIfAbsent(store.getName(), store);
    }

    private void validateCache() throws CoreException {
        if (this.resource instanceof RMProject && this.resource.getChildren() == null) {
            try {
                RemoteProjectImpl project = this.getRemoteProject();
                if (!project.isInitialized()) {
                    return;
                }
                this.resource = project.getResourceFromCache(this.fullPath);
            }
            catch (Exception e) {
                throw new CoreException(Status.error((String)("Error reading resource cache '" + String.valueOf(this.fullPath) + "'"), (Throwable)e));
            }
            if (this.resource == null) {
                throw new CoreException(Status.error((String)("Resource '" + String.valueOf(this.fullPath) + "' not found in cache")));
            }
        }
    }

    public void removeFromCache(String name) {
        this.childStores.remove(name);
    }

    private RemoteProjectImpl getRemoteProject() throws DBException {
        RemoteProjectImpl remoteProject = RemoteFileSystem.getRemoteProject(this.rootStore.toURI());
        if (remoteProject == null) {
            throw new DBException("Remote project not found for " + String.valueOf(this.rootStore.toURI()));
        }
        return remoteProject;
    }

    public String toString() {
        return this.fullPath.toString();
    }
}

