/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.ui.internal.preferences;

import com.dbeaver.model.datasource.DataSourceDescriptorPRO;
import com.dbeaver.model.datasource.parameters.DBPDatasourceExternalParameters;
import com.dbeaver.model.datasource.parameters.DBPParametersConfiguration;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderDescriptor;
import com.dbeaver.model.datasource.parameters.registry.DBPParametersProviderRegistry;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIServiceConnectionEditor;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.CommonUtils;

public class ConnectionEditorAdvanced
implements UIServiceConnectionEditor {
    private static final Log log = Log.getLog(ConnectionEditorAdvanced.class);
    private Text secretNameText;
    private List<? extends DBPParametersConfiguration> paramConfigs;
    private Combo configsCombo;
    private DBPDatasourceExternalParameters externalParams;
    private DBPParametersConfiguration selectedConfig;

    public void createControl(@NotNull Composite parent, DBPDataSourceContainer object, @NotNull Runnable propertyChangeListener) {
        DBPParametersProviderRegistry registry = DBPParametersProviderRegistry.getInstance();
        this.paramConfigs = registry.getAllConfigurations(false);
        if (this.paramConfigs.isEmpty() || !DBWorkbench.getPlatform().getWorkspace().isEnabledSecretProviders()) {
            return;
        }
        DBPParametersConfiguration singleConfig = this.paramConfigs.size() == 1 ? this.paramConfigs.get(0) : null;
        DBPParametersProviderDescriptor singleProvider = singleConfig == null ? null : registry.getProviderOrNull(singleConfig.getProviderId());
        Group group = UIUtils.createControlGroup((Composite)parent, (String)(singleProvider == null ? "Secret parameters" : singleProvider.getLabel()), (int)(singleConfig == null ? 4 : 2), (int)768, (int)-1);
        if (singleConfig == null) {
            this.configsCombo = UIUtils.createLabelCombo((Composite)group, (String)"Configuration", (String)"Secret parameters configuration", (int)12);
            this.configsCombo.add("None");
            this.configsCombo.addSelectionListener(SelectionListener.widgetSelectedAdapter(selectionEvent -> {
                int selectionIndex = this.configsCombo.getSelectionIndex();
                this.secretNameText.setEnabled(selectionIndex > 0);
                this.selectedConfig = selectionIndex <= 0 ? null : this.paramConfigs.get(selectionIndex - 1);
            }));
            this.configsCombo.setLayoutData((Object)new GridData(32));
            for (DBPParametersConfiguration dBPParametersConfiguration : this.paramConfigs) {
                this.configsCombo.add(dBPParametersConfiguration.getConfigurationName());
            }
        }
        this.secretNameText = UIUtils.createLabelText((Composite)group, (String)"Secret name", (String)"", (int)2048);
        this.secretNameText.addModifyListener(e -> propertyChangeListener.run());
        this.secretNameText.setEnabled(false);
    }

    public void loadSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        if (this.paramConfigs.isEmpty() || !DBWorkbench.getPlatform().getWorkspace().isEnabledSecretProviders()) {
            return;
        }
        if (this.paramConfigs.size() == 1) {
            this.selectedConfig = this.paramConfigs.get(0);
        }
        if (dataSourceContainer instanceof DataSourceDescriptorPRO) {
            DataSourceDescriptorPRO ddp = (DataSourceDescriptorPRO)dataSourceContainer;
            this.externalParams = ddp.getExternalParametersConfig();
            if (this.externalParams != null) {
                this.selectedConfig = null;
                if (!CommonUtils.isEmpty((String)this.externalParams.getConfigurationId())) {
                    try {
                        this.selectedConfig = DBPParametersProviderRegistry.getInstance().getProviderConfiguration(this.externalParams.getConfigurationId());
                    }
                    catch (DBCException e) {
                        log.debug((Object)e);
                    }
                }
                if (this.selectedConfig != null) {
                    if (this.configsCombo != null) {
                        this.configsCombo.setText(this.selectedConfig.getConfigurationName());
                    }
                    this.secretNameText.setText(CommonUtils.notEmpty((String)this.externalParams.getSecretName()));
                }
            }
            this.secretNameText.setEnabled(this.selectedConfig != null);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void saveSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
        void dsp;
        if (!(dataSourceContainer instanceof DataSourceDescriptorPRO)) {
            return;
        }
        DataSourceDescriptorPRO dataSourceDescriptorPRO = (DataSourceDescriptorPRO)dataSourceContainer;
        if (this.paramConfigs.isEmpty() || !DBWorkbench.getPlatform().getWorkspace().isEnabledSecretProviders() || this.selectedConfig == null) {
            dsp.setExternalParametersConfig(null);
            return;
        }
        String secretName = this.secretNameText.getText();
        if (CommonUtils.isEmpty((String)secretName)) {
            dsp.setExternalParametersConfig(null);
        } else {
            if (this.externalParams == null) {
                this.externalParams = new DBPDatasourceExternalParameters(this.selectedConfig.getConfigurationId(), secretName);
            } else {
                this.externalParams.setConfigurationId(this.selectedConfig.getConfigurationId());
                this.externalParams.setSecretName(secretName);
            }
            dsp.setExternalParametersConfig(this.externalParams);
        }
    }

    public void resetSettings(@NotNull DBPDataSourceContainer dataSourceContainer) {
    }

    public boolean isComplete() {
        return this.configsCombo == null || this.configsCombo.getSelectionIndex() > 0;
    }

    public boolean isExternalConfigurationProvided() {
        return this.secretNameText != null && !CommonUtils.isEmpty((String)this.secretNameText.getText());
    }
}

