/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.multi;

import com.dbeaver.jdbc.files.FFPropertiesFactory;
import com.dbeaver.jdbc.files.api.FFDataSourceFormat;
import com.dbeaver.jdbc.files.api.FFProperties;
import com.dbeaver.jdbc.files.api.FFPropertyInfo;
import com.dbeaver.jdbc.files.multi.MultiSourceJdbcDriver;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Stream;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public final class MultiSourceProperties
extends FFProperties {
    public static final FFPropertyInfo<FFDataSourceFormat> DATA_FORMAT_PROPERTY = FFPropertyInfo.builder().withName("dataFormat").withDescription("Data format").withChoices((Object[])FFDataSourceFormat.values()).withParser(FFDataSourceFormat::parse).build();
    private final Map<FFDataSourceFormat, FFPropertiesFactory<?>> factories = new HashMap();

    public MultiSourceProperties() {
        super(new Properties());
    }

    public MultiSourceProperties(@NotNull Map<String, String> properties) {
        super(properties);
        MultiSourceJdbcDriver.DELEGATE_DRIVERS.forEach(driver -> {
            FFPropertiesFactory fFPropertiesFactory = this.factories.put(driver.getSupportedDataSourceFormat(), driver.getPropertiesFactory());
        });
    }

    MultiSourceProperties(@NotNull Properties properties) {
        super(properties);
        MultiSourceJdbcDriver.DELEGATE_DRIVERS.forEach(driver -> {
            FFPropertiesFactory fFPropertiesFactory = this.factories.put(driver.getSupportedDataSourceFormat(), driver.getPropertiesFactory());
        });
    }

    @Nullable
    public FFDataSourceFormat dataFormat() {
        return (FFDataSourceFormat)this.getProperty(DATA_FORMAT_PROPERTY);
    }

    public String wildcard() {
        throw new UnsupportedOperationException("Wildcard is not supported for UniversalProperties");
    }

    @NotNull
    public List<FFPropertyInfo<?>> implementationProperties() {
        Stream delegatesProperties = this.factories.entrySet().stream().flatMap(entry -> ((FFPropertiesFactory)entry.getValue()).createProperties(new Properties()).implementationProperties().stream().filter(FFPropertyInfo::overridable).map(property -> MultiSourceProperties.addPrefix(property, ((FFDataSourceFormat)entry.getKey()).name().toLowerCase(Locale.ROOT))));
        return Stream.concat(Stream.of(DATA_FORMAT_PROPERTY), delegatesProperties).toList();
    }

    @NotNull
    private static <T> FFPropertyInfo<T> addPrefix(@NotNull FFPropertyInfo<T> property, @NotNull String prefix) {
        return FFPropertyInfo.from(property).withName(prefix + "." + property.name()).build();
    }

    @NotNull
    public <P extends FFProperties> P getPropertiesForFormat(@NotNull FFDataSourceFormat type) {
        Properties driverProperties = new Properties();
        this.properties.propertyNames().asIterator().forEachRemaining(key -> {
            String prefix;
            String keyStr = key.toString();
            if (keyStr.startsWith(prefix = type.name().toLowerCase(Locale.ROOT))) {
                String substring = keyStr.substring(prefix.length() + 1);
                driverProperties.setProperty(substring, this.properties.getProperty(keyStr));
            }
        });
        this.commonProperties().forEach(property -> {
            if (this.properties.containsKey(property.name())) {
                driverProperties.setProperty(property.name(), this.properties.getProperty(property.name()));
            }
        });
        FFPropertiesFactory<?> ffPropertiesFactory = this.factories.get(type);
        if (ffPropertiesFactory == null) {
            throw new IllegalArgumentException("No properties factory for type: " + String.valueOf(type));
        }
        return (P)ffPropertiesFactory.createProperties(driverProperties);
    }
}

