/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.remote.event.client;

import com.dbeaver.remote.event.client.WSClientEndpoint;
import com.google.gson.Gson;
import jakarta.websocket.ClientEndpointConfig;
import jakarta.websocket.Session;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.ee10.websocket.jakarta.client.JakartaWebSocketClientContainer;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.auth.SMCredentialsProvider;
import org.jkiss.dbeaver.model.websocket.WSUtils;
import org.jkiss.dbeaver.model.websocket.event.WSClientEvent;
import org.jkiss.dbeaver.model.websocket.event.WSEventController;

public class WSClient {
    private static final Log log = Log.getLog(WSClient.class);
    private static final Gson gson = WSUtils.gson;
    private final Object lock = new Object();
    private final AtomicBoolean reconnectOnDisconnect = new AtomicBoolean(true);
    private final AtomicBoolean pauseConnection = new AtomicBoolean(false);
    private final SMCredentialsProvider smCredentialsProvider;
    private final URI wsServerUri;
    private final WSClientEndpoint webSocket;
    private Session webSocketSession;
    private JakartaWebSocketClientContainer webSocketClientContainer;

    public WSClient(URI wsServerUri, SMCredentialsProvider smCredentialsProvider, WSEventController wsEventController) {
        this.wsServerUri = WSUtils.convertUriToWS((URI)wsServerUri);
        this.smCredentialsProvider = smCredentialsProvider;
        this.webSocket = new WSClientEndpoint(wsEventController);
    }

    /*
     * Exception decompiling
     */
    public void connect() throws DBException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void closeConnection() throws DBException {
        this.reconnectOnDisconnect.set(false);
        this.closeSession();
    }

    private synchronized void awaitTimeout() {
        try {
            log.debug((Object)"Waiting before trying to reconnect websocket");
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSession() throws DBException {
        Object object = this.lock;
        synchronized (object) {
            if (this.webSocketSession != null && this.webSocketSession.isOpen()) {
                try {
                    log.debug((Object)"Closing websocket session");
                    this.webSocketSession.close();
                    this.webSocketSession = null;
                }
                catch (Exception e) {
                    throw new DBException("Failed to close web socket session", (Throwable)e);
                }
            }
        }
    }

    public boolean isConnected() {
        return this.webSocketSession != null && this.webSocketSession.isOpen();
    }

    public void setPauseConnection(boolean pause) {
        this.pauseConnection.set(pause);
    }

    private ClientEndpointConfig getClientEndpointConfiguration() throws DBException {
        if (this.smCredentialsProvider.getActiveUserCredentials() == null) {
            throw new DBException("User not authorized");
        }
        final String smAccessToken = this.smCredentialsProvider.getActiveUserCredentials().getSmAccessToken();
        ClientEndpointConfig.Configurator configurator = new ClientEndpointConfig.Configurator(){

            public void beforeRequest(Map<String, List<String>> headers) {
                headers.put("SM-Auth-Token", List.of(smAccessToken));
            }
        };
        return ClientEndpointConfig.Builder.create().configurator(configurator).build();
    }

    public void sendMessage(WSClientEvent clientEvent) throws DBException {
        if (!this.isConnected()) {
            throw new DBException("WS session not connected");
        }
        String event = gson.toJson((Object)clientEvent);
        try {
            this.webSocketSession.getBasicRemote().sendText(event);
        }
        catch (IOException e) {
            throw new DBException("Failed to send ws client event", (Throwable)e);
        }
    }

    public class WSClientEndpointConfigurator
    extends ClientEndpointConfig.Configurator {
        @NotNull
        private final String smAccessToken;

        public WSClientEndpointConfigurator() throws DBException {
            if (WSClient.this.smCredentialsProvider.getActiveUserCredentials() == null) {
                throw new DBException("User not authorized");
            }
            this.smAccessToken = WSClient.this.smCredentialsProvider.getActiveUserCredentials().getSmAccessToken();
        }

        public void beforeRequest(Map<String, List<String>> headers) {
            headers.put("SM-Auth-Token", List.of(this.smAccessToken));
        }
    }
}

