/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.xlsx.impl;

import com.github.pjfanning.xlsx.impl.ooxml.HyperlinkData;
import java.net.URI;
import java.util.Objects;
import org.apache.poi.common.Duplicatable;
import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.util.AreaReference;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xssf.usermodel.XSSFHyperlink;

public class XlsxHyperlink
implements Hyperlink,
Duplicatable {
    private final HyperlinkType _type;
    private final PackageRelationship _externalRel;
    private final HyperlinkData hyperlinkData;
    private String _address;

    XlsxHyperlink(HyperlinkData hyperlinkData, PackageRelationship hyperlinkRel) {
        this.hyperlinkData = hyperlinkData;
        this._externalRel = hyperlinkRel;
        if (this._externalRel == null) {
            if (hyperlinkData.getLocation() != null) {
                this._type = HyperlinkType.DOCUMENT;
                this._address = hyperlinkData.getLocation();
            } else {
                if (hyperlinkData.getId() != null) {
                    throw new IllegalStateException("The hyperlink for cell " + hyperlinkData.getRef() + " references relation " + hyperlinkData.getId() + ", but that didn't exist!");
                }
                this._type = HyperlinkType.DOCUMENT;
            }
        } else {
            URI target = this._externalRel.getTargetURI();
            this._address = target.toString();
            if (hyperlinkData.getLocation() != null) {
                this._address = this._address + "#" + hyperlinkData.getLocation();
            }
            this._type = this._address.startsWith("http://") || this._address.startsWith("https://") || this._address.startsWith("ftp://") ? HyperlinkType.URL : (this._address.startsWith("mailto:") ? HyperlinkType.EMAIL : HyperlinkType.FILE);
        }
    }

    public HyperlinkType getType() {
        return this._type;
    }

    public String getCellRef() {
        return this.hyperlinkData.getRef();
    }

    public String getAddress() {
        return this._address;
    }

    private String getAddressWithoutLocation() {
        String addr = this._address;
        String locn = this.getLocation();
        if (addr != null && !addr.equals(locn) && addr.endsWith(locn)) {
            return addr.substring(0, addr.length() - locn.length() - 1);
        }
        return addr;
    }

    public String getLabel() {
        return this.hyperlinkData.getDisplay();
    }

    public String getLocation() {
        return this.hyperlinkData.getLocation();
    }

    private CellReference buildFirstCellReference() {
        return this.buildCellReference(false);
    }

    private CellReference buildLastCellReference() {
        return this.buildCellReference(true);
    }

    private CellReference buildCellReference(boolean lastCell) {
        String ref = this.hyperlinkData.getRef();
        if (ref == null) {
            ref = "A1";
        }
        if (ref.contains(":")) {
            AreaReference area = new AreaReference(ref, SpreadsheetVersion.EXCEL2007);
            return lastCell ? area.getLastCell() : area.getFirstCell();
        }
        return new CellReference(ref);
    }

    public int getFirstColumn() {
        return this.buildFirstCellReference().getCol();
    }

    public int getLastColumn() {
        return this.buildLastCellReference().getCol();
    }

    public int getFirstRow() {
        return this.buildFirstCellReference().getRow();
    }

    public int getLastRow() {
        return this.buildLastCellReference().getRow();
    }

    public String getTooltip() {
        return this.hyperlinkData.getTooltip();
    }

    public void setAddress(String address) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setLabel(String label) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setFirstColumn(int col) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setLastColumn(int col) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setFirstRow(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public void setLastRow(int row) {
        throw new UnsupportedOperationException("update operations are not supported");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XlsxHyperlink that = (XlsxHyperlink)o;
        return this._type == that._type && Objects.equals(this._externalRel, that._externalRel) && Objects.equals(this.hyperlinkData, that.hyperlinkData) && Objects.equals(this._address, that._address);
    }

    public int hashCode() {
        return Objects.hash(this._type, this._externalRel, this.hyperlinkData, this._address);
    }

    public Duplicatable copy() {
        return new XlsxHyperlink(this.hyperlinkData, this._externalRel);
    }

    public XSSFHyperlink createXSSFHyperlink() {
        XSSFHyperlink xssfHyperlink = new XSSFHyperlink(this.getType()){};
        xssfHyperlink.setFirstRow(this.getFirstRow());
        xssfHyperlink.setLastRow(this.getLastRow());
        xssfHyperlink.setFirstColumn(this.getFirstColumn());
        xssfHyperlink.setLastColumn(this.getLastColumn());
        xssfHyperlink.setLabel(this.getLabel());
        xssfHyperlink.setTooltip(this.getTooltip());
        xssfHyperlink.setAddress(this.getAddressWithoutLocation());
        xssfHyperlink.setLocation(this.getLocation());
        return xssfHyperlink;
    }
}

