/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.couchbase.client.core.error.RequestCanceledException;
import com.couchbase.client.java.manager.collection.CollectionSpec;
import com.couchbase.client.java.manager.collection.ScopeSpec;
import com.dbeaver.db.couchbase3.exec.CouchbaseExecutionContext;
import com.dbeaver.db.couchbase3.model.CouchbaseBucket;
import com.dbeaver.db.couchbase3.model.CouchbaseCollection;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import com.dbeaver.model.document.DBAbstractDocumentContainer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPSaveableObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.cache.BasicObjectCache;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;

public class CouchbaseScope
implements DBSCatalog,
DBPSaveableObject,
DBPRefreshableObject {
    private final CouchbaseBucket parent;
    private final CouchbaseDataSource dataSource;
    private final ScopeSpec scope;
    private boolean persisted = true;
    private final CollectionsCache collectionsCache = new CollectionsCache();

    public CouchbaseScope(ScopeSpec scope, CouchbaseDataSource dataSource, CouchbaseBucket bucket) {
        this.scope = scope;
        this.dataSource = dataSource;
        this.parent = bucket;
    }

    @Property(viewable=true, order=10)
    @NotNull
    public String getName() {
        return this.scope.name();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return this.persisted;
    }

    @NotNull
    public DBSObject getParentObject() {
        return this.parent;
    }

    @Nullable
    public CouchbaseDataSource getDataSource() {
        return this.dataSource;
    }

    @Nullable
    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.collectionsCache.clearCache();
        return this;
    }

    public void setPersisted(boolean persisted) {
        this.persisted = persisted;
    }

    public Collection<? extends DBSObject> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.collectionsCache.getAllObjects(monitor, this);
    }

    @Nullable
    public DBSObject getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.collectionsCache.getObject(monitor, (DBSObject)this, childName);
    }

    @NotNull
    public Class<? extends DBSObject> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return CouchbaseCollection.class;
    }

    @Association
    @NotNull
    public Collection<? extends DBAbstractDocumentContainer> getCollections(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.collectionsCache.getAllObjects(monitor, this);
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
        this.collectionsCache.getAllObjects(monitor, this);
    }

    public class CollectionsCache
    extends BasicObjectCache<CouchbaseScope, CouchbaseCollection> {
        @NotNull
        public Collection<CouchbaseCollection> getAllObjects(@NotNull DBRProgressMonitor monitor, @Nullable CouchbaseScope couchbaseScope) throws DBException {
            if (!this.isFullyCached() && !monitor.isForceCacheUsage()) {
                ArrayList<CouchbaseCollection> collections = new ArrayList<CouchbaseCollection>();
                try {
                    List allScopes = ((CouchbaseExecutionContext)CouchbaseScope.this.dataSource.getDefaultContext()).getCluster().bucket(CouchbaseScope.this.getParentObject().getName()).collections().getAllScopes();
                    for (ScopeSpec scope : allScopes) {
                        if (!scope.name().equals(CouchbaseScope.this.getName())) continue;
                        for (CollectionSpec collection : scope.collections()) {
                            collections.add(new CouchbaseCollection(CouchbaseScope.this.dataSource, collection, CouchbaseScope.this));
                        }
                    }
                }
                catch (RequestCanceledException requestCanceledException) {
                }
                catch (Exception ex) {
                    throw new DBCException("Exception when getting collections", (Throwable)ex);
                }
                this.setCache(collections);
                collections.sort(DBUtils.nameComparator());
                return collections;
            }
            return this.getCachedObjects();
        }
    }
}

