/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3.model;

import com.couchbase.client.java.json.JsonArray;
import com.couchbase.client.java.json.JsonObject;
import com.dbeaver.db.couchbase3.model.CouchbaseCollection;
import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAttributeRef;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;
import org.jkiss.dbeaver.model.struct.rdb.DBSTableConstraint;

public class CouchbaseCollectionIndex
implements DBSTableConstraint {
    private static final Log log = Log.getLog(CouchbaseCollectionIndex.class);
    private final CouchbaseCollection collection;
    private final JsonObject nodeDesc;

    public CouchbaseCollectionIndex(CouchbaseCollection collection, JsonObject nodeDesc) {
        this.collection = collection;
        this.nodeDesc = nodeDesc;
    }

    @NotNull
    public CouchbaseDataSource getDataSource() {
        return (CouchbaseDataSource)this.collection.getDataSource();
    }

    @Property(viewable=true, editable=true, order=1)
    @NotNull
    public String getName() {
        return this.nodeDesc.getString("name");
    }

    @Property(editable=true, order=2)
    public String getIndexID() {
        return this.nodeDesc.getString("id");
    }

    @Property(viewable=true, editable=true, order=3)
    public String getState() {
        return this.nodeDesc.getString("state");
    }

    @Property(viewable=true, editable=true, order=4)
    public String getUsing() {
        return this.nodeDesc.getString("using");
    }

    @Property(viewable=true, editable=true, order=5)
    public String getCondition() {
        return this.nodeDesc.getString("condition");
    }

    @Property(viewable=true, editable=true, order=6)
    public List<String> getKeys() {
        JsonArray indexKey = this.nodeDesc.getArray("index_key");
        ArrayList<String> result = new ArrayList<String>();
        if (indexKey != null) {
            int i = 0;
            while (i < indexKey.size()) {
                result.add(indexKey.getString(i));
                ++i;
            }
        }
        return result;
    }

    public String getDescription() {
        return null;
    }

    @NotNull
    public CouchbaseCollection getParentObject() {
        return this.collection;
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.INDEX;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getFullyQualifiedName(@NotNull DBPEvaluationContext context) {
        return this.getName();
    }

    @Nullable
    public List<? extends DBSEntityAttributeRef> getAttributeReferences(@Nullable DBRProgressMonitor monitor) throws DBException {
        return null;
    }
}

