/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.couchbase3;

import com.dbeaver.db.couchbase3.model.CouchbaseDataSource;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceProvider;
import org.jkiss.dbeaver.model.app.DBPPlatform;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.impl.PropertyDescriptor;
import org.jkiss.dbeaver.model.preferences.DBPPropertyDescriptor;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.utils.CommonUtils;

public class CouchbaseDataSourceProvider
implements DBPDataSourceProvider {
    private static final Log log = Log.getLog(CouchbaseDataSourceProvider.class);

    public void init(@NotNull DBPPlatform platform) {
    }

    public long getFeatures() {
        return 2L;
    }

    @NotNull
    public DBPPropertyDescriptor[] getConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) throws DBException {
        return new DBPPropertyDescriptor[]{new PropertyDescriptor("Timeouts", "couchbase.connectionTimeout", "Connection Timeout", "The default timeout for connect operations.", Long.class, false, (Object)5000, null, true), new PropertyDescriptor("Timeouts", "couchbase.analyticsTimeout", "Analytics Timeout", "The default timeout for analytics operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("Timeouts", "couchbase.kvTimeout", "KV Timeout", "The default timeout for binary (key/value) operations.", Long.class, false, (Object)2500, null, true), new PropertyDescriptor("Timeouts", "couchbase.queryTimeout", "Query Timeout", "The default timeout for query operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("Timeouts", "couchbase.managementTimeout", "Management Timeout", "The default timeout for management operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("Timeouts", "couchbase.searchTimeout", "Search Timeout", "The default timeout for search operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("Timeouts", "couchbase.viewTimeout", "View Timeout", "The default timeout for view operations.", Long.class, false, (Object)75000, null, true), new PropertyDescriptor("SSL", "couchbase.sslKeystoreFile", "Keystore file", "SSL keystore file.", String.class, false, null, null, true), new PropertyDescriptor("SSL", "couchbase.sslKeystorePassword", "Keystore password", "SSL keystore password.", String.class, false, null, null, true)};
    }

    @NotNull
    public String getConnectionURL(@NotNull DBPDriver driver, @NotNull DBPConnectionConfiguration connectionInfo) {
        String port = connectionInfo.getHostPort();
        String host = connectionInfo.getHostName();
        return CommonUtils.isNotEmpty((String)port) ? host + ":" + port : host;
    }

    @NotNull
    public DBPDataSource openDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        return new CouchbaseDataSource(monitor, container);
    }
}

