/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.redis.exec;

import com.dbeaver.db.redis.RedisUtils;
import com.dbeaver.db.redis.exec.RedisBaseResultSet;
import com.dbeaver.db.redis.exec.RedisBaseStatement;
import com.dbeaver.db.redis.exec.RedisResultSetSimple;
import com.dbeaver.db.redis.exec.RedisSession;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.qm.QMUtils;
import redis.clients.jedis.commands.ScriptingKeyCommands;

public class RedisQueryStatement
extends RedisBaseStatement {
    protected Object result;

    public RedisQueryStatement(RedisSession session, String query) {
        super(session, query, 0L, 0L);
    }

    public boolean executeStatement() throws DBCException {
        if (((RedisSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementExecuteBegin((DBCStatement)this);
        }
        try {
            RedisUtils.selectCurDatabase((RedisSession)this.getSession());
            if (!((RedisSession)this.getSession()).supportsCommands(ScriptingKeyCommands.class)) {
                throw new DBCException("Eval command not supported");
            }
            ScriptingKeyCommands jedis = ((RedisSession)this.getSession()).getCommands(ScriptingKeyCommands.class);
            this.result = jedis.eval(this.getQueryString());
            boolean bl = this.result != null;
            return bl;
        }
        catch (Throwable e) {
            throw this.handleExecuteError(e);
        }
        finally {
            if (((RedisSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, -1L, this.executeError);
            }
        }
    }

    public RedisBaseResultSet openResultSet() throws DBCException {
        if (this.result == null) {
            return null;
        }
        return new RedisResultSetSimple(this, this.result, this.offset);
    }
}

