/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.bigquery.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.bigquery.database.BigQueryDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AddPrimaryKeyGenerator;
import liquibase.statement.core.AddPrimaryKeyStatement;
import liquibase.structure.DatabaseObject;

public class BigQueryAddPrimaryKeyConstraintGenerator
extends AddPrimaryKeyGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(AddPrimaryKeyStatement statement, Database database) {
        return database instanceof BigQueryDatabase;
    }

    public Sql[] generateSql(AddPrimaryKeyStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String sql = String.format("ALTER TABLE %s ADD PRIMARY KEY (%s) NOT ENFORCED", database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()), database.escapeColumnNameList(statement.getColumnNames()));
        return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedPrimaryKey(statement)})};
    }
}

