/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.NetworkIsolationSettings;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ExportDatabaseDefinition {
    @JsonProperty(value="storageKeyType", required=true)
    private StorageKeyType storageKeyType;
    @JsonProperty(value="storageKey", required=true)
    private String storageKey;
    @JsonProperty(value="storageUri", required=true)
    private String storageUri;
    @JsonProperty(value="administratorLogin", required=true)
    private String administratorLogin;
    @JsonProperty(value="administratorLoginPassword", required=true)
    private String administratorLoginPassword;
    @JsonProperty(value="authenticationType")
    private String authenticationType;
    @JsonProperty(value="networkIsolation")
    private NetworkIsolationSettings networkIsolation;
    private static final ClientLogger LOGGER = new ClientLogger(ExportDatabaseDefinition.class);

    public StorageKeyType storageKeyType() {
        return this.storageKeyType;
    }

    public ExportDatabaseDefinition withStorageKeyType(StorageKeyType storageKeyType) {
        this.storageKeyType = storageKeyType;
        return this;
    }

    public String storageKey() {
        return this.storageKey;
    }

    public ExportDatabaseDefinition withStorageKey(String storageKey) {
        this.storageKey = storageKey;
        return this;
    }

    public String storageUri() {
        return this.storageUri;
    }

    public ExportDatabaseDefinition withStorageUri(String storageUri) {
        this.storageUri = storageUri;
        return this;
    }

    public String administratorLogin() {
        return this.administratorLogin;
    }

    public ExportDatabaseDefinition withAdministratorLogin(String administratorLogin) {
        this.administratorLogin = administratorLogin;
        return this;
    }

    public String administratorLoginPassword() {
        return this.administratorLoginPassword;
    }

    public ExportDatabaseDefinition withAdministratorLoginPassword(String administratorLoginPassword) {
        this.administratorLoginPassword = administratorLoginPassword;
        return this;
    }

    public String authenticationType() {
        return this.authenticationType;
    }

    public ExportDatabaseDefinition withAuthenticationType(String authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public NetworkIsolationSettings networkIsolation() {
        return this.networkIsolation;
    }

    public ExportDatabaseDefinition withNetworkIsolation(NetworkIsolationSettings networkIsolation) {
        this.networkIsolation = networkIsolation;
        return this;
    }

    public void validate() {
        if (this.storageKeyType() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageKeyType in model ExportDatabaseDefinition"));
        }
        if (this.storageKey() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageKey in model ExportDatabaseDefinition"));
        }
        if (this.storageUri() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property storageUri in model ExportDatabaseDefinition"));
        }
        if (this.administratorLogin() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property administratorLogin in model ExportDatabaseDefinition"));
        }
        if (this.administratorLoginPassword() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property administratorLoginPassword in model ExportDatabaseDefinition"));
        }
        if (this.networkIsolation() != null) {
            this.networkIsolation().validate();
        }
    }
}

