/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.redshift.database;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import liquibase.database.DatabaseConnection;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.ForeignKey;
import liquibase.util.StringUtil;

public class RedshiftDatabase
extends PostgresDatabase {
    private static final int HIGH_PRIORITY = 5;
    private Set<String> redshiftReservedWords = new HashSet<String>();

    public RedshiftDatabase() {
        super.setCurrentDateTimeFunction("GETDATE()");
        this.redshiftReservedWords.addAll(Arrays.asList("AES128", "AES256", "ALL", "ALLOWOVERWRITE", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", "AUTHORIZATION", "BACKUP", "BETWEEN", "BINARY", "BLANKSASNULL", "BOTH", "BYTEDICT", "CASE", "CAST", "CHECK", "COLLATE", "COLUMN", "CONSTRAINT", "CREATE", "CREDENTIALS", "CROSS", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURRENT_USER_ID", "DEFAULT", "DEFERRABLE", "DEFLATE", "DEFRAG", "DELTA", "DELTA32K", "DESC", "DISABLE", "DISTINCT", "DO", "ELSE", "EMPTYASNULL", "ENABLE", "ENCODE", "ENCRYPT     ", "ENCRYPTION", "END", "EXCEPT", "EXPLICIT", "FALSE", "FOR", "FOREIGN", "FREEZE", "FROM", "FULL", "GLOBALDICT256", "GLOBALDICT64K", "GRANT", "GROUP", "GZIP", "HAVING", "IDENTITY", "IGNORE", "ILIKE", "IN", "INITIALLY", "INNER", "INTERSECT", "INTO", "IS", "ISNULL", "JOIN", "LEADING", "LEFT", "LIKE", "LIMIT", "LOCALTIME", "LOCALTIMESTAMP", "LUN", "LUNS", "LZO", "LZOP", "MINUS", "MOSTLY13", "MOSTLY32", "MOSTLY8", "NATURAL", "NEW", "NOT", "NOTNULL", "NULL", "NULLS", "OFF", "OFFLINE", "OFFSET", "OLD", "ON", "ONLY", "OPEN", "OR", "ORDER", "OUTER", "OVERLAPS", "PARALLEL", "PARTITION", "PERCENT", "PLACING", "PRIMARY", "RAW", "READRATIO", "RECOVER", "REFERENCES", "REJECTLOG", "RESORT", "RESTORE", "RIGHT", "SELECT", "SESSION_USER", "SIMILAR", "SOME", "SYSDATE", "SYSTEM", "TABLE", "TAG", "TDES", "TEXT255", "TEXT32K", "THEN", "TO", "TOP", "TRAILING", "TRUE", "TRUNCATECOLUMNS", "UNION", "UNIQUE", "USER", "USING", "VERBOSE", "WALLET", "WHEN", "WHERE", "WITH", "WITHOUT"));
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return StringUtil.trimToEmpty((String)System.getProperty("liquibase.ext.redshift.force")).equalsIgnoreCase("true") || conn.getURL().contains("redshift") || conn.getURL().contains(":5439");
    }

    public String getShortName() {
        return "redshift";
    }

    protected String getDefaultDatabaseProductName() {
        return "Redshift";
    }

    public int getPriority() {
        return 5;
    }

    public boolean isReservedWord(String tableName) {
        if (super.isReservedWord(tableName)) {
            return true;
        }
        return this.redshiftReservedWords.contains(tableName.toUpperCase());
    }

    public String escapeObjectName(String objectName, Class<? extends DatabaseObject> objectType) {
        if (objectName != null) {
            if (this.mustQuoteObjectName(objectName = objectName.trim(), objectType)) {
                return this.quoteObject(objectName, objectType);
            }
            if (this.quotingStrategy == ObjectQuotingStrategy.QUOTE_ALL_OBJECTS) {
                return this.quoteObject(objectName, objectType);
            }
        }
        return objectName;
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:postgresql:")) {
            return "org.postgresql.Driver";
        }
        if (url.startsWith("jdbc:redshift:")) {
            return "com.amazon.redshift.jdbc42.Driver";
        }
        return null;
    }

    public Integer getDefaultPort() {
        return 5439;
    }

    public String getCurrentDateTimeFunction() {
        return "GETDATE()";
    }

    protected SqlStatement getConnectionSchemaNameCallStatement() {
        return new RawSqlStatement("select current_schema()");
    }

    public boolean supportsDDLInTransaction() {
        return false;
    }

    public boolean supports(Class<? extends DatabaseObject> object) {
        if (ForeignKey.class.isAssignableFrom(object)) {
            return false;
        }
        return super.supports(object);
    }
}

