/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.model;

import com.dbeaver.db.kafka.model.KSQLDataSource;
import com.dbeaver.db.kafka.model.KSQLTopic;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.utils.CommonUtils;

public class KSQLQuery
implements DBSObject,
DBPScriptObject {
    private final KSQLDataSource dataSource;
    private final JsonObject queryInfo;
    private final List<KSQLTopic> topic = new ArrayList<KSQLTopic>();
    private ArrayList<String> statuses;

    public KSQLQuery(@NotNull JsonObject queryInfo, @Nullable KSQLDataSource ksqlDataSource, @NotNull DBRProgressMonitor monitor) throws DBException {
        this.dataSource = ksqlDataSource;
        this.queryInfo = queryInfo;
        JsonElement sinkKafkaTopics = queryInfo.get("sinks");
        if (sinkKafkaTopics != null && this.dataSource != null && sinkKafkaTopics instanceof List) {
            for (Object sinkKafkaTopic : (List)sinkKafkaTopics) {
                this.topic.add(this.dataSource.getTopic(monitor, (String)sinkKafkaTopic));
            }
        }
    }

    @Property(order=0, viewable=true)
    @NotNull
    public String getName() {
        return this.queryInfo.get("id").getAsString();
    }

    @Property(order=1, viewable=true)
    @NotNull
    public String getType() {
        return this.queryInfo.get("queryType").getAsString();
    }

    @Property(order=2, viewable=true)
    @Nullable
    public List<String> getSink() {
        JsonArray sinks = this.queryInfo.get("sinks").getAsJsonArray();
        ArrayList<String> result = new ArrayList<String>();
        for (JsonElement sink : sinks) {
            result.add(sink.getAsString());
        }
        return result;
    }

    @Property(order=3, viewable=true)
    @NotNull
    public List<KSQLTopic> getSinkTopic() {
        return this.topic;
    }

    @Property(order=4, viewable=true)
    @NotNull
    public String getState() {
        return this.queryInfo.get("state").getAsString();
    }

    @Property(order=5, viewable=true)
    @NotNull
    public List<String> getStatuses() {
        if (this.statuses == null) {
            JsonObject statusCount = this.queryInfo.get("statusCount").getAsJsonObject();
            this.statuses = new ArrayList();
            for (Map.Entry o : statusCount.entrySet()) {
                if (CommonUtils.toInt((Object)((JsonElement)o.getValue()).getAsInt()) != 1) continue;
                this.statuses.add((String)o.getKey());
            }
        }
        return this.statuses;
    }

    public String getDescription() {
        return "";
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.getDataSource();
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @Property(viewable=true)
    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) {
        return this.queryInfo.get("queryString").getAsString();
    }
}

