/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.model;

import com.dbeaver.db.kafka.model.KSQLDataSource;
import io.confluent.ksql.api.client.ConnectorInfo;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class KSQLConnector
implements DBSObject {
    private final ConnectorInfo connectorInfo;
    private final KSQLDataSource dataSource;

    public KSQLConnector(@Nullable KSQLDataSource dataSource, @NotNull ConnectorInfo connectorInfo) {
        this.dataSource = dataSource;
        this.connectorInfo = connectorInfo;
    }

    @Property(order=0, viewable=true)
    @NotNull
    public String getName() {
        return this.connectorInfo.name();
    }

    @Property(order=1, viewable=true)
    public String getState() {
        return this.connectorInfo.state();
    }

    @Property(order=2, viewable=true)
    public String getConnectorType() {
        return this.connectorInfo.type().getType().name();
    }

    @Property(order=3, viewable=true)
    public String getClassName() {
        return this.connectorInfo.className();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    @Nullable
    public DBSObject getParentObject() {
        return this.dataSource;
    }

    @Nullable
    public DBPDataSource getDataSource() {
        return this.dataSource;
    }
}

