/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.exec;

import com.dbeaver.db.kafka.KSQLConstants;
import com.dbeaver.db.kafka.exec.KSQLBaseStatement;
import com.dbeaver.db.kafka.exec.KSQLExecutionContext;
import com.dbeaver.db.kafka.exec.KSQLSelectStatement;
import com.dbeaver.db.kafka.model.KSQLDataSource;
import java.util.Locale;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.impl.AbstractSession;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLUtils;

public class KSQLSession
extends AbstractSession {
    private static final Log log = Log.getLog(KSQLSession.class);
    private final KSQLExecutionContext executionContext;

    public KSQLSession(DBRProgressMonitor monitor, DBCExecutionPurpose purpose, String taskTitle, KSQLExecutionContext executionContext) {
        super(monitor, purpose, taskTitle);
        this.executionContext = executionContext;
    }

    @NotNull
    public KSQLExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public KSQLDataSource getDataSource() {
        return (KSQLDataSource)this.executionContext.getDataSource();
    }

    @NotNull
    public DBCStatement prepareStatement(@NotNull DBCStatementType type, @NotNull String query, boolean scrollable, boolean updatable, boolean returnGeneratedKeys) throws DBCException {
        String testQuery = SQLUtils.stripComments((SQLDialect)this.getDataSource().getSQLDialect(), (String)query);
        if (KSQLConstants.READ_QUERY_PATTERN.matcher(testQuery.toLowerCase(Locale.ROOT)).matches()) {
            return new KSQLSelectStatement(this, query + ";");
        }
        return new KSQLBaseStatement(this, query + ";");
    }

    public void cancelBlock(@NotNull DBRProgressMonitor monitor, @Nullable Thread blockThread) throws DBException {
        if (blockThread != null) {
            blockThread.interrupt();
        }
    }

    public void close() {
        super.close();
    }
}

