/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.kafka.exec;

import com.dbeaver.db.kafka.exec.KSQLBaseStatement;
import com.dbeaver.db.kafka.exec.KSQLPushResultSet;
import com.dbeaver.db.kafka.exec.KSQLSession;
import io.confluent.ksql.api.client.BatchedQueryResult;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.impl.AbstractResultSet;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.utils.CommonUtils;

public class KSQLSelectStatement
extends KSQLBaseStatement {
    private static final Log log = Log.getLog(KSQLSelectStatement.class);
    private long limit;
    private long offset;
    private AbstractResultSet resultSet;
    protected long updateCount = -1L;
    private int statementTimeout;

    public KSQLSelectStatement(@NotNull KSQLSession session, @NotNull String queryText) {
        super(session, queryText);
        this.statementTimeout = session.getExecutionContext().getRequestTimeout();
        if (((KSQLSession)this.getSession()).isLoggingEnabled()) {
            QMUtils.getDefaultHandler().handleStatementOpen((DBCStatement)this);
        }
    }

    @Override
    public boolean executeStatement() throws DBCException {
        if (CommonUtils.isEmpty((String)this.getQueryString())) {
            return true;
        }
        if (this.getQueryString().toLowerCase(Locale.ROOT).contains("emit changes")) {
            throw new DBCException("Pull selects are not supported by DBeaver");
        }
        String queryString = this.getQueryString();
        Exception executeError = null;
        try {
            try {
                BatchedQueryResult batchedQueryResult = ((KSQLSession)this.getSession()).getExecutionContext().getKsqlClient().executeQuery(queryString);
                this.resultSet = new KSQLPushResultSet(this, (List)batchedQueryResult.get((long)this.statementTimeout, TimeUnit.MILLISECONDS), this.getOffset());
            }
            catch (Exception e) {
                log.error((Object)e);
                executeError = e;
                throw new DBCException(CommonUtils.getRootCause((Throwable)e), (DBCExecutionContext)((KSQLSession)this.getSession()).getExecutionContext());
            }
        }
        finally {
            if (((KSQLSession)this.getSession()).isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleStatementExecuteEnd((DBCStatement)this, this.getUpdateRowCount(), (Throwable)executeError);
            }
        }
        return true;
    }

    @Override
    @Nullable
    public DBCResultSet openResultSet() {
        return this.resultSet;
    }

    @Override
    public long getUpdateRowCount() {
        return this.updateCount;
    }

    @Override
    public boolean nextResults() throws DBCException {
        return this.resultSet.nextRow();
    }

    @Override
    public void setLimit(long offset, long limit) {
        this.offset = offset;
        this.limit = limit;
    }

    @Override
    @Nullable
    public Throwable[] getStatementWarnings() {
        return null;
    }

    @Override
    public void setStatementTimeout(int timeout) {
        this.statementTimeout = timeout;
    }

    @Override
    public void setResultsFetchSize(int fetchSize) {
    }

    public long getLimit() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }
}

