/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.database;

import java.sql.SQLType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jkiss.code.Nullable;

public enum FFSQLType implements SQLType
{
    BIT(-7),
    TINYINT(-6),
    SMALLINT(5),
    INTEGER(4, Set.of("INT")),
    BIGINT(-5),
    FLOAT(6),
    REAL(7),
    DOUBLE(8),
    NUMERIC(2),
    DECIMAL(3),
    CHAR(1),
    VARCHAR(12),
    LONGVARCHAR(-1),
    DATE(91),
    TIME(92),
    TIMESTAMP(93, Set.of("DATETIME")),
    BINARY(-2),
    VARBINARY(-3),
    LONGVARBINARY(-4),
    STRUCT(2002),
    ARRAY(2003),
    BLOB(2004),
    CLOB(2005),
    BOOLEAN(16),
    NCHAR(-15),
    NVARCHAR(-9),
    LONGNVARCHAR(-16),
    NCLOB(2011),
    SQLXML(2009),
    TIME_WITH_TIMEZONE(2013),
    TIMESTAMP_WITH_TIMEZONE(2014),
    NULL(0),
    GEOMETRY(1111),
    GEOGRAPHY(1111),
    POINT(1111),
    LINESTRING(1111),
    POLYGON(1111),
    MULTIPOINT(1111),
    MULTILINESTRING(1111),
    MULTIPOLYGON(1111),
    GEOMETRYCOLLECTION(1111),
    CIRCULARSTRING(1111),
    COMPOUNDCURVE(1111),
    CURVEPOLYGON(1111),
    MULTICURVE(1111),
    MULTISURFACE(1111),
    POLYHEDRALSURFACE(1111),
    TIN(1111),
    TRIANGLE(1111),
    RASTER(1111),
    TOPOGEOMETRY(1111),
    BOX2D(1111),
    BOX3D(1111);

    private final Integer type;
    private final Set<String> aliases;
    private static final Map<String, FFSQLType> LOOKUP_MAP;

    static {
        HashMap<String, FFSQLType> map = new HashMap<String, FFSQLType>();
        FFSQLType[] fFSQLTypeArray = FFSQLType.values();
        int n = fFSQLTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FFSQLType sqlType = fFSQLTypeArray[n2];
            map.put(sqlType.name().toUpperCase(Locale.ROOT), sqlType);
            sqlType.aliases.forEach(alias -> {
                FFSQLType fFSQLType2 = map.put(alias.toUpperCase(Locale.ROOT), sqlType);
            });
            ++n2;
        }
        LOOKUP_MAP = Collections.unmodifiableMap(map);
    }

    private FFSQLType(Integer type) {
        this(type, null);
    }

    private FFSQLType(Integer type, Set<String> aliases) {
        this.type = type;
        this.aliases = aliases != null ? aliases : Set.of();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public String getVendor() {
        return "com.dbeaver.jdbc";
    }

    @Override
    public Integer getVendorTypeNumber() {
        return this.type;
    }

    @Nullable
    public static SQLType parse(@Nullable String columnDataTypeDefinition) {
        if (columnDataTypeDefinition == null || columnDataTypeDefinition.isBlank()) {
            return null;
        }
        String normalized = columnDataTypeDefinition.trim().toUpperCase(Locale.ROOT);
        return LOOKUP_MAP.get(normalized);
    }

    public static FFSQLType valueOf(String string) {
        return Enum.valueOf(FFSQLType.class, string);
    }
}

