/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.jdbc.files.api;

import com.dbeaver.jdbc.files.FFStatementFactory;
import com.dbeaver.jdbc.files.api.FFDatabaseMetaData;
import com.dbeaver.jdbc.files.database.FFDatabase;
import com.dbeaver.jdbc.files.utils.FFDriverUtils;
import com.dbeaver.jdbc.files.utils.FFExceptionUtils;
import com.dbeaver.jdbc.model.AbstractJdbcConnection;
import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Function;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;

public class FFConnection
extends AbstractJdbcConnection {
    @NotNull
    private final FFDatabase database;
    @NotNull
    private final Function<FFConnection, FFDatabaseMetaData> databaseMetaDataFactory;
    @NotNull
    private final FFStatementFactory statementFactory;
    private volatile String currentSchema;
    private final CompletableFuture<Void> closeFuture = new CompletableFuture();
    private final WarningStore warnings = new WarningStore();
    private final Set<Statement> stmts = Collections.newSetFromMap(Collections.synchronizedMap(new IdentityHashMap()));

    public FFConnection(@NotNull FFDatabase database, @NotNull Function<FFConnection, FFDatabaseMetaData> databaseMetaDataFactory, @NotNull FFStatementFactory statementFactory, @Nullable String defaultSchema) {
        this.database = database;
        this.databaseMetaDataFactory = databaseMetaDataFactory;
        this.currentSchema = defaultSchema;
        this.statementFactory = statementFactory;
    }

    public void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.closeFuture.complete(null);
        ArrayList<Exception> errors = new ArrayList<Exception>();
        try {
            FFDriverUtils.closeAll(this.stmts.toArray(new Statement[0]));
        }
        catch (Exception e) {
            errors.add(e);
        }
        this.stmts.clear();
        if (!errors.isEmpty()) {
            throw FFExceptionUtils.combine(SQLException::new, "Failed to close connection", errors);
        }
    }

    public boolean isClosed() throws SQLException {
        return this.closeFuture.isDone();
    }

    public CompletableFuture<Void> getCloseFuture() {
        return this.closeFuture;
    }

    @NotNull
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureOpen();
        return (DatabaseMetaData)((Object)this.databaseMetaDataFactory.apply(this));
    }

    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @NotNull
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        Statement statement = this.statementFactory.createStatement(this, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.stmts.add(statement);
        return statement;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.prepareStatement(sql, resultSetType, resultSetConcurrency, 2);
    }

    @NotNull
    public PreparedStatement prepareStatement(@NotNull String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        PreparedStatement statement = this.statementFactory.prepareStatement(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.stmts.add(statement);
        return statement;
    }

    @NotNull
    public CallableStatement prepareCall(@NotNull String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        this.ensureOpen();
        CallableStatement statement = this.statementFactory.prepareCall(this, sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        this.stmts.add(statement);
        return statement;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureOpen();
        if (!readOnly) {
            throw new SQLFeatureNotSupportedException("Only read-only mode is supported");
        }
    }

    public boolean isReadOnly() throws SQLException {
        this.ensureOpen();
        return true;
    }

    public void setCatalog(String catalog) throws SQLException {
        this.ensureOpen();
    }

    public String getCatalog() throws SQLException {
        this.ensureOpen();
        return null;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.ensureOpen();
        return this.warnings.toChain();
    }

    public void clearWarnings() throws SQLException {
        this.ensureOpen();
        this.warnings.clear();
    }

    public void setSchema(@NotNull String schema) throws SQLException {
        this.ensureOpen();
        this.currentSchema = schema;
    }

    @NotNull
    public String getSchema() throws SQLException {
        this.ensureOpen();
        return this.currentSchema;
    }

    @NotNull
    public FFDatabase getDatabase() throws SQLException {
        this.ensureOpen();
        return this.database;
    }

    void removeStatement(@NotNull Statement statement) {
        this.stmts.remove(statement);
    }

    void ensureOpen() throws SQLException {
        if (this.isClosed()) {
            throw new SQLException("Connection is closed");
        }
    }

    void addWarning(Throwable cause) {
        this.warnings.addWarning(cause);
    }

    private static class WarningStore {
        private final Queue<SQLWarning> warnings = new ConcurrentLinkedQueue<SQLWarning>();

        private WarningStore() {
        }

        public void addWarning(Throwable cause) {
            this.warnings.offer(new SQLWarning(cause));
        }

        public void clear() {
            this.warnings.clear();
        }

        public SQLWarning toChain() {
            SQLWarning first;
            Iterator it = this.warnings.iterator();
            if (!it.hasNext()) {
                return null;
            }
            SQLWarning current = first = (SQLWarning)it.next();
            while (it.hasNext()) {
                SQLWarning next = (SQLWarning)it.next();
                current.setNextWarning(next);
                current = next;
            }
            return first;
        }
    }
}

