/*
 * Decompiled with CFR 0.152.
 */
package com.dbeaver.db.snowflake.model;

import java.sql.Connection;
import java.sql.SQLException;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ext.snowflake.model.SnowflakeDataSource;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLUtils;
import org.jkiss.utils.CommonUtils;

public class SnowflakeChangeUserPasswordManager
implements DBAUserPasswordManager {
    private static final Log log = Log.getLog(SnowflakeChangeUserPasswordManager.class);
    private SnowflakeDataSource dataSource;

    SnowflakeChangeUserPasswordManager(SnowflakeDataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void changeUserPassword(@NotNull DBRProgressMonitor monitor, @NotNull String userName, @NotNull String newPassword, @NotNull String oldPassword) throws DBException {
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this.dataSource, (String)"Change user password");){
                try {
                    Throwable throwable2 = null;
                    Object var9_14 = null;
                    try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT CURRENT_USER()");){
                        Throwable throwable3 = null;
                        Object var12_19 = null;
                        try (JDBCResultSet resultSet = dbStat.executeQuery();){
                            String string;
                            if (resultSet.next() && CommonUtils.isNotEmpty((String)(string = resultSet.getString(1)))) {
                                userName = string;
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable e) {
                    log.error((Object)"Can't read current user name. Use user name from connection settings instead.", e);
                }
                session.enableLogging(false);
                JDBCUtils.executeSQL((Connection)session, (String)("ALTER USER " + DBUtils.getQuotedIdentifier((DBPDataSource)this.dataSource, (String)userName) + " SET PASSWORD =" + SQLUtils.quoteString((DBPDataSource)this.dataSource, (String)CommonUtils.notEmpty((String)newPassword))), (Object[])new Object[0]);
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            throw new DBCException("Error changing user password", (Throwable)e);
        }
    }
}

