/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterSnapshotCopyStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterSnapshotCopyStatus> {
    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DestinationRegion").getter(ClusterSnapshotCopyStatus.getter(ClusterSnapshotCopyStatus::destinationRegion)).setter(ClusterSnapshotCopyStatus.setter(Builder::destinationRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()}).build();
    private static final SdkField<Long> RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("RetentionPeriod").getter(ClusterSnapshotCopyStatus.getter(ClusterSnapshotCopyStatus::retentionPeriod)).setter(ClusterSnapshotCopyStatus.setter(Builder::retentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPeriod").build()}).build();
    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManualSnapshotRetentionPeriod").getter(ClusterSnapshotCopyStatus.getter(ClusterSnapshotCopyStatus::manualSnapshotRetentionPeriod)).setter(ClusterSnapshotCopyStatus.setter(Builder::manualSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<String> SNAPSHOT_COPY_GRANT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotCopyGrantName").getter(ClusterSnapshotCopyStatus.getter(ClusterSnapshotCopyStatus::snapshotCopyGrantName)).setter(ClusterSnapshotCopyStatus.setter(Builder::snapshotCopyGrantName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCopyGrantName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_REGION_FIELD, RETENTION_PERIOD_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, SNAPSHOT_COPY_GRANT_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterSnapshotCopyStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String destinationRegion;
    private final Long retentionPeriod;
    private final Integer manualSnapshotRetentionPeriod;
    private final String snapshotCopyGrantName;

    private ClusterSnapshotCopyStatus(BuilderImpl builder) {
        this.destinationRegion = builder.destinationRegion;
        this.retentionPeriod = builder.retentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
    }

    public final String destinationRegion() {
        return this.destinationRegion;
    }

    public final Long retentionPeriod() {
        return this.retentionPeriod;
    }

    public final Integer manualSnapshotRetentionPeriod() {
        return this.manualSnapshotRetentionPeriod;
    }

    public final String snapshotCopyGrantName() {
        return this.snapshotCopyGrantName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.retentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotCopyGrantName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSnapshotCopyStatus)) {
            return false;
        }
        ClusterSnapshotCopyStatus other = (ClusterSnapshotCopyStatus)obj;
        return Objects.equals(this.destinationRegion(), other.destinationRegion()) && Objects.equals(this.retentionPeriod(), other.retentionPeriod()) && Objects.equals(this.manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod()) && Objects.equals(this.snapshotCopyGrantName(), other.snapshotCopyGrantName());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterSnapshotCopyStatus").add("DestinationRegion", (Object)this.destinationRegion()).add("RetentionPeriod", (Object)this.retentionPeriod()).add("ManualSnapshotRetentionPeriod", (Object)this.manualSnapshotRetentionPeriod()).add("SnapshotCopyGrantName", (Object)this.snapshotCopyGrantName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationRegion": {
                return Optional.ofNullable(clazz.cast(this.destinationRegion()));
            }
            case "RetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.retentionPeriod()));
            }
            case "ManualSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.manualSnapshotRetentionPeriod()));
            }
            case "SnapshotCopyGrantName": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyGrantName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DestinationRegion", DESTINATION_REGION_FIELD);
        map.put("RetentionPeriod", RETENTION_PERIOD_FIELD);
        map.put("ManualSnapshotRetentionPeriod", MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD);
        map.put("SnapshotCopyGrantName", SNAPSHOT_COPY_GRANT_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterSnapshotCopyStatus, T> g) {
        return obj -> g.apply((ClusterSnapshotCopyStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationRegion;
        private Long retentionPeriod;
        private Integer manualSnapshotRetentionPeriod;
        private String snapshotCopyGrantName;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSnapshotCopyStatus model) {
            this.destinationRegion(model.destinationRegion);
            this.retentionPeriod(model.retentionPeriod);
            this.manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            this.snapshotCopyGrantName(model.snapshotCopyGrantName);
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final Long getRetentionPeriod() {
            return this.retentionPeriod;
        }

        public final void setRetentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public ClusterSnapshotCopyStatus build() {
            return new ClusterSnapshotCopyStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterSnapshotCopyStatus> {
        public Builder destinationRegion(String var1);

        public Builder retentionPeriod(Long var1);

        public Builder manualSnapshotRetentionPeriod(Integer var1);

        public Builder snapshotCopyGrantName(String var1);
    }
}

