/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.models.EnableStatusEnum;
import java.io.IOException;

public final class Storage
implements JsonSerializable<Storage> {
    private Integer storageSizeGB;
    private Integer iops;
    private EnableStatusEnum autoGrow;
    private String storageSku;

    public Integer storageSizeGB() {
        return this.storageSizeGB;
    }

    public Storage withStorageSizeGB(Integer storageSizeGB) {
        this.storageSizeGB = storageSizeGB;
        return this;
    }

    public Integer iops() {
        return this.iops;
    }

    public Storage withIops(Integer iops) {
        this.iops = iops;
        return this;
    }

    public EnableStatusEnum autoGrow() {
        return this.autoGrow;
    }

    public Storage withAutoGrow(EnableStatusEnum autoGrow) {
        this.autoGrow = autoGrow;
        return this;
    }

    public String storageSku() {
        return this.storageSku;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("storageSizeGB", (Number)this.storageSizeGB);
        jsonWriter.writeNumberField("iops", (Number)this.iops);
        jsonWriter.writeStringField("autoGrow", this.autoGrow == null ? null : this.autoGrow.toString());
        return jsonWriter.writeEndObject();
    }

    public static Storage fromJson(JsonReader jsonReader) throws IOException {
        return (Storage)jsonReader.readObject(reader -> {
            Storage deserializedStorage = new Storage();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("storageSizeGB".equals(fieldName)) {
                    deserializedStorage.storageSizeGB = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("iops".equals(fieldName)) {
                    deserializedStorage.iops = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("autoGrow".equals(fieldName)) {
                    deserializedStorage.autoGrow = EnableStatusEnum.fromString(reader.getString());
                    continue;
                }
                if ("storageSku".equals(fieldName)) {
                    deserializedStorage.storageSku = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedStorage;
        });
    }
}

