/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.models.EnableStatusEnum;
import java.io.IOException;

public final class ServerRestartParameter
implements JsonSerializable<ServerRestartParameter> {
    private EnableStatusEnum restartWithFailover;
    private Integer maxFailoverSeconds;

    public EnableStatusEnum restartWithFailover() {
        return this.restartWithFailover;
    }

    public ServerRestartParameter withRestartWithFailover(EnableStatusEnum restartWithFailover) {
        this.restartWithFailover = restartWithFailover;
        return this;
    }

    public Integer maxFailoverSeconds() {
        return this.maxFailoverSeconds;
    }

    public ServerRestartParameter withMaxFailoverSeconds(Integer maxFailoverSeconds) {
        this.maxFailoverSeconds = maxFailoverSeconds;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("restartWithFailover", this.restartWithFailover == null ? null : this.restartWithFailover.toString());
        jsonWriter.writeNumberField("maxFailoverSeconds", (Number)this.maxFailoverSeconds);
        return jsonWriter.writeEndObject();
    }

    public static ServerRestartParameter fromJson(JsonReader jsonReader) throws IOException {
        return (ServerRestartParameter)jsonReader.readObject(reader -> {
            ServerRestartParameter deserializedServerRestartParameter = new ServerRestartParameter();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("restartWithFailover".equals(fieldName)) {
                    deserializedServerRestartParameter.restartWithFailover = EnableStatusEnum.fromString(reader.getString());
                    continue;
                }
                if ("maxFailoverSeconds".equals(fieldName)) {
                    deserializedServerRestartParameter.maxFailoverSeconds = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedServerRestartParameter;
        });
    }
}

