/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.mysqlflexibleserver.models.DataEncryptionType;
import java.io.IOException;

public final class DataEncryption
implements JsonSerializable<DataEncryption> {
    private String primaryUserAssignedIdentityId;
    private String primaryKeyUri;
    private String geoBackupUserAssignedIdentityId;
    private String geoBackupKeyUri;
    private DataEncryptionType type;

    public String primaryUserAssignedIdentityId() {
        return this.primaryUserAssignedIdentityId;
    }

    public DataEncryption withPrimaryUserAssignedIdentityId(String primaryUserAssignedIdentityId) {
        this.primaryUserAssignedIdentityId = primaryUserAssignedIdentityId;
        return this;
    }

    public String primaryKeyUri() {
        return this.primaryKeyUri;
    }

    public DataEncryption withPrimaryKeyUri(String primaryKeyUri) {
        this.primaryKeyUri = primaryKeyUri;
        return this;
    }

    public String geoBackupUserAssignedIdentityId() {
        return this.geoBackupUserAssignedIdentityId;
    }

    public DataEncryption withGeoBackupUserAssignedIdentityId(String geoBackupUserAssignedIdentityId) {
        this.geoBackupUserAssignedIdentityId = geoBackupUserAssignedIdentityId;
        return this;
    }

    public String geoBackupKeyUri() {
        return this.geoBackupKeyUri;
    }

    public DataEncryption withGeoBackupKeyUri(String geoBackupKeyUri) {
        this.geoBackupKeyUri = geoBackupKeyUri;
        return this;
    }

    public DataEncryptionType type() {
        return this.type;
    }

    public DataEncryption withType(DataEncryptionType type) {
        this.type = type;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("primaryUserAssignedIdentityId", this.primaryUserAssignedIdentityId);
        jsonWriter.writeStringField("primaryKeyURI", this.primaryKeyUri);
        jsonWriter.writeStringField("geoBackupUserAssignedIdentityId", this.geoBackupUserAssignedIdentityId);
        jsonWriter.writeStringField("geoBackupKeyURI", this.geoBackupKeyUri);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static DataEncryption fromJson(JsonReader jsonReader) throws IOException {
        return (DataEncryption)jsonReader.readObject(reader -> {
            DataEncryption deserializedDataEncryption = new DataEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("primaryUserAssignedIdentityId".equals(fieldName)) {
                    deserializedDataEncryption.primaryUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("primaryKeyURI".equals(fieldName)) {
                    deserializedDataEncryption.primaryKeyUri = reader.getString();
                    continue;
                }
                if ("geoBackupUserAssignedIdentityId".equals(fieldName)) {
                    deserializedDataEncryption.geoBackupUserAssignedIdentityId = reader.getString();
                    continue;
                }
                if ("geoBackupKeyURI".equals(fieldName)) {
                    deserializedDataEncryption.geoBackupKeyUri = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedDataEncryption.type = DataEncryptionType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataEncryption;
        });
    }
}

