/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.FirewallRuleInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.mysqlflexibleserver.models.FirewallRule;

public final class FirewallRuleImpl
implements FirewallRule,
FirewallRule.Definition,
FirewallRule.Update {
    private FirewallRuleInner innerObject;
    private final MySqlManager serviceManager;
    private String resourceGroupName;
    private String serverName;
    private String firewallRuleName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public SystemData systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String startIpAddress() {
        return this.innerModel().startIpAddress();
    }

    @Override
    public String endIpAddress() {
        return this.innerModel().endIpAddress();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public FirewallRuleInner innerModel() {
        return this.innerObject;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }

    @Override
    public FirewallRuleImpl withExistingFlexibleServer(String resourceGroupName, String serverName) {
        this.resourceGroupName = resourceGroupName;
        this.serverName = serverName;
        return this;
    }

    @Override
    public FirewallRule create() {
        this.innerObject = this.serviceManager.serviceClient().getFirewallRules().createOrUpdate(this.resourceGroupName, this.serverName, this.firewallRuleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public FirewallRule create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFirewallRules().createOrUpdate(this.resourceGroupName, this.serverName, this.firewallRuleName, this.innerModel(), context);
        return this;
    }

    FirewallRuleImpl(String name, MySqlManager serviceManager) {
        this.innerObject = new FirewallRuleInner();
        this.serviceManager = serviceManager;
        this.firewallRuleName = name;
    }

    @Override
    public FirewallRuleImpl update() {
        return this;
    }

    @Override
    public FirewallRule apply() {
        this.innerObject = this.serviceManager.serviceClient().getFirewallRules().createOrUpdate(this.resourceGroupName, this.serverName, this.firewallRuleName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public FirewallRule apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getFirewallRules().createOrUpdate(this.resourceGroupName, this.serverName, this.firewallRuleName, this.innerModel(), context);
        return this;
    }

    FirewallRuleImpl(FirewallRuleInner innerObject, MySqlManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.serverName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "flexibleServers");
        this.firewallRuleName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "firewallRules");
    }

    @Override
    public FirewallRule refresh() {
        this.innerObject = (FirewallRuleInner)((Object)this.serviceManager.serviceClient().getFirewallRules().getWithResponse(this.resourceGroupName, this.serverName, this.firewallRuleName, Context.NONE).getValue());
        return this;
    }

    @Override
    public FirewallRule refresh(Context context) {
        this.innerObject = (FirewallRuleInner)((Object)this.serviceManager.serviceClient().getFirewallRules().getWithResponse(this.resourceGroupName, this.serverName, this.firewallRuleName, context).getValue());
        return this;
    }

    @Override
    public FirewallRuleImpl withStartIpAddress(String startIpAddress) {
        this.innerModel().withStartIpAddress(startIpAddress);
        return this;
    }

    @Override
    public FirewallRuleImpl withEndIpAddress(String endIpAddress) {
        this.innerModel().withEndIpAddress(endIpAddress);
        return this;
    }
}

