/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.CheckNameAvailabilitiesClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.NameAvailabilityInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.MySqlManagementClientImpl;
import com.azure.resourcemanager.mysqlflexibleserver.models.NameAvailabilityRequest;
import reactor.core.publisher.Mono;

public final class CheckNameAvailabilitiesClientImpl
implements CheckNameAvailabilitiesClient {
    private final CheckNameAvailabilitiesService service;
    private final MySqlManagementClientImpl client;

    CheckNameAvailabilitiesClientImpl(MySqlManagementClientImpl client) {
        this.service = (CheckNameAvailabilitiesService)RestProxy.create(CheckNameAvailabilitiesService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NameAvailabilityInner>> executeWithResponseAsync(String locationName, NameAvailabilityRequest nameAvailabilityRequest) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (nameAvailabilityRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nameAvailabilityRequest is required and cannot be null."));
        }
        nameAvailabilityRequest.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.execute(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), locationName, nameAvailabilityRequest, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<NameAvailabilityInner>> executeWithResponseAsync(String locationName, NameAvailabilityRequest nameAvailabilityRequest, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (locationName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter locationName is required and cannot be null."));
        }
        if (nameAvailabilityRequest == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nameAvailabilityRequest is required and cannot be null."));
        }
        nameAvailabilityRequest.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.execute(this.client.getEndpoint(), this.client.getApiVersion(), this.client.getSubscriptionId(), locationName, nameAvailabilityRequest, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<NameAvailabilityInner> executeAsync(String locationName, NameAvailabilityRequest nameAvailabilityRequest) {
        return this.executeWithResponseAsync(locationName, nameAvailabilityRequest).flatMap(res -> Mono.justOrEmpty((Object)((NameAvailabilityInner)res.getValue())));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<NameAvailabilityInner> executeWithResponse(String locationName, NameAvailabilityRequest nameAvailabilityRequest, Context context) {
        return (Response)this.executeWithResponseAsync(locationName, nameAvailabilityRequest, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public NameAvailabilityInner execute(String locationName, NameAvailabilityRequest nameAvailabilityRequest) {
        return (NameAvailabilityInner)this.executeWithResponse(locationName, nameAvailabilityRequest, Context.NONE).getValue();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="MySqlManagementClien")
    public static interface CheckNameAvailabilitiesService {
        @Headers(value={"Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/providers/Microsoft.DBforMySQL/locations/{locationName}/checkNameAvailability")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<NameAvailabilityInner>> execute(@HostParam(value="$host") String var1, @QueryParam(value="api-version") String var2, @PathParam(value="subscriptionId") String var3, @PathParam(value="locationName") String var4, @BodyParam(value="application/json") NameAvailabilityRequest var5, @HeaderParam(value="Accept") String var6, Context var7);
    }
}

