/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.mysqlflexibleserver.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.mysqlflexibleserver.MySqlManager;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.BackupsClient;
import com.azure.resourcemanager.mysqlflexibleserver.fluent.models.ServerBackupInner;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.mysqlflexibleserver.implementation.ServerBackupImpl;
import com.azure.resourcemanager.mysqlflexibleserver.models.Backups;
import com.azure.resourcemanager.mysqlflexibleserver.models.ServerBackup;

public final class BackupsImpl
implements Backups {
    private static final ClientLogger LOGGER = new ClientLogger(BackupsImpl.class);
    private final BackupsClient innerClient;
    private final MySqlManager serviceManager;

    public BackupsImpl(BackupsClient innerClient, MySqlManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    @Override
    public Response<ServerBackup> getWithResponse(String resourceGroupName, String serverName, String backupName, Context context) {
        Response<ServerBackupInner> inner = this.serviceClient().getWithResponse(resourceGroupName, serverName, backupName, context);
        if (inner != null) {
            return new SimpleResponse(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(), (Object)new ServerBackupImpl((ServerBackupInner)((Object)inner.getValue()), this.manager()));
        }
        return null;
    }

    @Override
    public ServerBackup get(String resourceGroupName, String serverName, String backupName) {
        ServerBackupInner inner = this.serviceClient().get(resourceGroupName, serverName, backupName);
        if (inner != null) {
            return new ServerBackupImpl(inner, this.manager());
        }
        return null;
    }

    @Override
    public PagedIterable<ServerBackup> listByServer(String resourceGroupName, String serverName) {
        PagedIterable<ServerBackupInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerBackupImpl((ServerBackupInner)((Object)inner1), this.manager()));
    }

    @Override
    public PagedIterable<ServerBackup> listByServer(String resourceGroupName, String serverName, Context context) {
        PagedIterable<ServerBackupInner> inner = this.serviceClient().listByServer(resourceGroupName, serverName, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ServerBackupImpl((ServerBackupInner)((Object)inner1), this.manager()));
    }

    private BackupsClient serviceClient() {
        return this.innerClient;
    }

    private MySqlManager manager() {
        return this.serviceManager;
    }
}

